#include <stdio.h>

#include <gscm.h>
/*
#include <tcl.h>
#include <tk.h>
*/

#include "c_builtins.h"


static GSCM_status guile_init()
{
#if 0				/* don't need fancy packages */
  scm_init_ctax();
  scm_init_unix();
  scm_init_posix();
  scm_init_ioext();
  scm_init_gtcl();
  scm_init_gtk();
#endif /* 0 */
}

main(int argc, char *argv[])
{
  GSCM_status status;
  GSCM_top_level toplev;
  char *eval_answer;
  char input_str[200];		/* ugly hack: assume strlen(line) < 200 */
  int done;

  printf("hello guile\n");

  /* start an interpreter */
#if 0				/* this is the old way */
  status = initialize_gscm(0, argc, argv);
#endif /* 0 */
  /* start a scheme interpreter */
  status = gscm_run_scm(argc, argv, 0, stdout, stderr, guile_init, 0, "#t");
  if (status != GSCM_OK) {
    fputs(gscm_error_msg(status), stderr);
    fputc('\n', stderr);
    exit(1);
  }

  /* create the top level environment */
  status = gscm_create_top_level(&toplev);
  if (status != GSCM_OK) {
    fputs(gscm_error_msg(status), stderr);
    fputc('\n', stderr);
    exit(1);
  }

  /* now some code to prepare a Tk main window; the scheme code would be
   * something like
   * (define tk-main (tk-init-main-window (tcl-create-interp) "papageno:0"
   *                   "john" "john2")`w)
   * where I am still confused about the "name" and "class" parameters
   * involved.
   */
  /* ...abandoned for a while; can't figure it out */
  

  /* for fun, evaluate some simple scheme expressions here */
  status = gscm_eval_str(NULL, toplev, "(define (square x) (* x x))");
  status = gscm_eval_str(NULL, toplev, "(define (factorial n) (if (= n 1) 1 (* n (factorial (- n 1)))))");
  status = gscm_eval_str(NULL, toplev, "(square 9)");
  status = gscm_eval_str(NULL, toplev, "(factorial 100)");

  /* now try to define some new builtins, coded in C, so that they
   * are available in scheme.  note that I have put junk in the documentation
   * strings because I have not yet read the manual on how doc strings
   * should be written :-|
   */
  gscm_define_procedure("c-factorial", c_factorial, 1, 1, 0, "hi there");
  gscm_define_procedure("c-sin", c_sin, 1, 1, 0, "hi there");
  gscm_define_procedure("v-t", vector_test, 1, 1, 0, "hi there");

  /* now sit in a scheme eval loop: I input the expressions, have guile
   * evaluate them, and then get another expression.
   */
  done = 0;
  fputs("learn1> ", stdout);
  while (!done) {
    if (gets(input_str) == NULL || strcmp(input_str, "(quit)") == 0) {
      done = 1;
    } else {
      status = gscm_eval_str(NULL, toplev, input_str);
      fputs("learn1> ", stdout);
    }
  }

  /* now clean up and quit */
  gscm_destroy_top_level(toplev);
  exit(0);
}
