#!/usr/local/bin/perl
#
# stopMonitor.pl 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

#Main program

use Schedule::Cron;
use Getopt::Long;
use Time::ParseDate;
use Cwd;
use File::Spec;

use strict;

package launcher;

sub CronDispatcher {
	my $self = shift;

	return;

}

sub _PrintUsage {
	my $errMsg = shift;

	$errMsg .= "\nUsage : perl $0 --context=contextid --basedir=/path/to/base/dir [--ldaphome=/path/to/ldap/home] [--connector=connectorId\n";

	$errMsg .="Example time perl $0  --context=default --basedir=/home/app/cafeterra --ldaphome=/home/app/cafeterra/default --connector=88\n";
	die $errMsg;
}

sub _ProcessOptions {
	my %config;

	Getopt::Long::GetOptions(\%config, "context=s", "basedir=s", "ldaphome=s", "connector=s");

	_PrintUsage ("") unless ($config{context} and $config{basedir});

	$config{contextId} = $config{context};

	_PrintUsage("Can't change to basedir $config{basedir}\n") unless ($config{basedir} and (chdir $config{basedir}));

	my $cwd = Cwd::getcwd;

	_PrintUsage("Can't change to basedir $config{context}\n") unless ($config{context} and (chdir $config{context}));

	chdir $cwd;

	require mains::SchedRt;
	require mains::FlowTls;
	require mains::FlowRt;
	require mains::SFlowRt;
	require mains::FlowSubs;
#	require mains::FlowScrs;

	require connectors::cafDBI;
	require connectors::refDBI;
	require connectors::cafQry;
	require connectors::refQry;

	my $found;
	my $usermodfound = undef;
	my $usermod = "$config{basedir}/usermod";
	$usermod =~ s/\/\//\//g;

	foreach my $dir (@INC) {
		if ($dir eq $config{basedir}) { $found = "yes" }
		if ($dir eq $usermod) { $usermodfound = "yes" }
		last if ($found and $usermodfound);
	} 

	push @INC, $config{basedir} unless ($found);
	push @INC, $usermod unless ($usermodfound);

	my $confpkg = $config{context} . "::conf";
	eval "require $confpkg";

	_PrintUsage("Can't load $confpkg\n$@") if ($@);


	require tools::cafUtils;
	require tools::cafDbg;

	$config{ldaphome} ||=  $ENV{LDAP_HOME};
	$config{ldaphome} ||=  File::Spec->catdir($config{basedir}, $config{contextId}, "ldapdb");

	mkdir $config{ldaphome} unless (-d $config{ldaphome});

	die "Can't chdir to $config{ldaphome}" unless ($config{ldaphome});

	\%config;

}

sub BuildLDBFiles {

	my $cfg = _ProcessOptions();

	my %qdb = %{CTXTCFG->refdb()};

	my %user = ( username => $qdb{user}{username}, password => $qdb{user}{password});
	$qdb{user} = \%user;

	my %qattrs;
	foreach my $k (keys %{$qdb{_ATTRS}}) {
	$qattrs{$k} = $qdb{_ATTRS}{$k};
	}
	$qattrs{PrintError} = undef; $qattrs{RaiseError} = 1; $qattrs{AutoCommit} = 1;
	$qdb{_ATTRS} = \%qattrs;

	my $qDbh = refDBI->Connect(\%qdb) || die "Can't connect(1) to Queue Database \n $@";
	die "Unable to connect to queue Database : " . refDBI->errstr() unless ($qDbh);

	require connectors::cafdLDAP;
	require connectors::ObjHier;
	cafdLDAP->BuildLDBFile($cfg->{context}, $qDbh, $cfg->{connector}, $cfg->{ldaphome});

}

#Instance variables
#Running subflows
#Running 

BuildLDBFiles();
