#!/usr/local/bin/perl
#
# sqlscripts.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package InitObjAndData;
my $sqlObjects = {
  'protocol' => [
    'CREATE TABLE protocol (
	protocolid character varying(10) NOT NULL,
	protocollabel character varying(50) NOT NULL,
	inoutdir character varying(10) DEFAULT \'inout\',
	Constraint protocol_pkey Primary Key (protocolid)
)'
  ],
  'wwaitevents' => [
    'CREATE TABLE wwaitevents (
	object_id integer NOT NULL,
	object_id_source integer NOT NULL,
	eventid character varying(30) NOT NULL,
	received timestamp with time zone DEFAULT now() NOT NULL,
	Constraint wwaitevents_pkey Primary Key (eventid, object_id, object_id_source)
)'
  ],
  'mapping' => [
    'CREATE TABLE mapping (
	subflow_id integer NOT NULL,
	outgofield_id integer NOT NULL,
	incomfield_id integer NOT NULL,
	script_id integer,
	formula character varying(500),
	pformula character varying(500),
	Constraint mapping_pkey Primary Key (outgofield_id, subflow_id)
)'
  ],
  'subflow' => [
    'CREATE TABLE subflow (
	object_id integer NOT NULL,
	flow_id integer NOT NULL,
	container_id integer NOT NULL,
	floworder smallint NOT NULL,
	flowdirection character varying(10) NOT NULL,
	flowmethod character varying(20),
	dependant character varying(10) DEFAULT \'no\',
	direct character varying(10) DEFAULT \'no\',
	onoutgoerr character varying(20),
	keepalive character varying(10) DEFAULT \'no\',
	mailonerr character varying(10) DEFAULT \'yes\',
	mailonsucc character varying(10) DEFAULT \'no\',
	Constraint subflow_pkey Primary Key (object_id)
)',
    'CREATE UNIQUE INDEX subflow_ukey1 on subflow using btree ( container_id int4_ops, flow_id int4_ops, flowdirection varchar_ops, floworder int2_ops )'
  ],
  'scriptobject' => [
    'CREATE TABLE scriptobject (
	object_id integer NOT NULL,
	script_id integer NOT NULL,
	step character varying(10) NOT NULL,
	comments character varying(250),
	usedfor character varying(20),
	Constraint scriptobject_pkey Primary Key (object_id, script_id, step)
)'
  ],
  'pscripts' => [
    'CREATE TABLE pscripts (
	object_id integer NOT NULL,
	parsetext character varying,
	Constraint pscripts_pkey Primary Key (object_id)
)'
  ],
  'wvars' => [
    'CREATE TABLE wvars (
	object_id integer NOT NULL,
	varid character varying(50) NOT NULL,
	specialvar character varying(32) DEFAULT \'varValues\' NOT NULL,
	datatype character varying(50) DEFAULT \'scalar\' NOT NULL,
	created timestamp with time zone DEFAULT now() NOT NULL,
	modified timestamp with time zone NOT NULL,
	varvalue character varying NOT NULL,
	Constraint wvars_pkey Primary Key (object_id, specialvar, varid)
)'
  ],
  'cafproxy' => [
    'CREATE TABLE cafproxy (
	object_id integer NOT NULL,
	user_id integer NOT NULL,
	port varchar(20) NOT NULL,
	dbidsn character varying(250),
	cipher character varying,
	key character varying,
	usercipher character varying,
	userkey character varying,
	compression character varying(20),
	Constraint cafproxy_pkey Primary Key (object_id)
)'
  ],
  'flow' => [
    'CREATE TABLE flow (
	object_id integer NOT NULL,
	flowmethod character varying(20),
	onerror character varying(20),
	bufferedflow character varying(10) DEFAULT \'yes\',
	incomrel character varying(20) DEFAULT \'independant\',
	commitinterv smallint DEFAULT 1,
	flowtype character varying(10) DEFAULT \'simple\',
	Constraint flow_pkey Primary Key (object_id)
)'
  ],
  'deployedobjects' => [
    'CREATE TABLE deployedobjects (
	contextid character varying(50) NOT NULL,
	object_id integer NOT NULL,
	created timestamp with time zone DEFAULT now() NOT NULL,
	modified timestamp with time zone DEFAULT now() NOT NULL,
	committed character varying(20) DEFAULT \'yes\' NOT NULL,
	Constraint deployedobjects_pkey Primary Key (contextid, object_id)
)'
  ],
  'server' => [
    'CREATE TABLE server (
	object_id integer NOT NULL,
	host_name character varying(50),
	host_address character varying(50),
	Constraint server_pkey Primary Key (object_id)
)'
  ],
  'scripts' => [
    'CREATE TABLE scripts (
	object_id integer NOT NULL,
	scripttype character varying(20) DEFAULT \'user\' NOT NULL,
	parsed character varying(10) DEFAULT \'no\' NOT NULL,
	scripttext character varying,
	Constraint scripts_pkey Primary Key (object_id)
)'
  ],
  'objectevents' => [
    'CREATE TABLE objectevents (
	object_id integer NOT NULL,
	eventid character varying(30) NOT NULL,
	genorwait character varying(20) DEFAULT \'generate\' NOT NULL,
	object_id_source integer,
	waitlast character varying(10) DEFAULT \'yes\',
	expiredelay smallint,
	comments character varying(250),
	Constraint objectevents_pkey Primary Key (eventid, genorwait, object_id)
)',
    'CREATE UNIQUE INDEX objectevents_object_id_key on objectevents using btree ( eventid varchar_ops, genorwait varchar_ops, object_id int4_ops, object_id_source int4_ops )'
  ],
  'field' => [
    'CREATE TABLE field (
	object_id integer NOT NULL,
	externalname character varying(50) NOT NULL,
	datatypeid character varying(20) DEFAULT \'varchar\' NOT NULL,
	datalength smallint NOT NULL,
	datascale smallint,
	dataformat character varying(50),
	fieldorder smallint NOT NULL,
	fieldpos smallint,
	keyposition smallint,
	localfield character varying(3) DEFAULT \'no\' NOT NULL,
	referto_id integer,
	xmlnode character varying(50),
	defaultvalue character varying(250),
	nullable character varying(10) DEFAULT \'yes\',
	Constraint field_pkey Primary Key (object_id)
)'
  ],
  'wscheduler' => [
    'CREATE TABLE wscheduler (
	sched_id character varying(20) NOT NULL,
	sched_label character varying(100),
	object_id integer NOT NULL,
	sched_created timestamp with time zone NOT NULL,
	sched_modified timestamp with time zone NOT NULL,
	sched_min character varying(50) NOT NULL,
	sched_hour character varying(50) NOT NULL,
	sched_mday character varying(50) NOT NULL,
	sched_month character varying(50) NOT NULL,
	sched_wday character varying(50) NOT NULL,
	sched_mode character varying(10) DEFAULT \'once\' NOT NULL,
	sched_status character varying(10) DEFAULT \'online\' NOT NULL,
	tracefile character varying(250),
	errorfile character varying(250),
	sched_secs character varying(50),
	Constraint wscheduler_pkey Primary Key (sched_id)
)',
    'CREATE  INDEX wscheduler_object_id_key on wscheduler using btree ( object_id int4_ops )',
    'CREATE  INDEX wscheduler_sched_status_key on wscheduler using btree ( sched_status varchar_ops )'
  ],
  'wrunerrors' => [
    'CREATE TABLE wrunerrors (
	error_id integer NOT NULL,
	object_id integer DEFAULT -1 NOT NULL,
	msg_id integer DEFAULT -1 NOT NULL,
	run_id integer NOT NULL,
	error_date timestamp with time zone NOT NULL,
	error_context character varying(120) DEFAULT \'unknouwn\' NOT NULL,
	error_code character varying(20) DEFAULT \'999999\' NOT NULL,
	driver_error character varying(40),
	error_text character varying,
	last_query character varying,
	stack_dump character varying,
	Constraint wrunerrors_pkey Primary Key (error_id)
)'
  ],
  'otherobjects' => [
    'CREATE TABLE otherobjects (
	parent_id integer NOT NULL,
	child_id integer NOT NULL,
	Constraint otherobjects_pkey Primary Key (child_id, parent_id)
)'
  ],
  'wrunhisto_seq' => [
    'CREATE SEQUENCE wrunhisto_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1 '
  ],
  'waddresses' => [
    'CREATE TABLE waddresses (
	addressid character varying(30) NOT NULL,
	addresslabel character varying(100) NOT NULL,
	addresstype character varying(10) DEFAULT \'address\' NOT NULL,
	email character varying(100),
	faxnumber character varying(100),
	mobilenumber character varying(100),
	printercmd character varying(100),
	address_line1 character varying(100),
	address_line2 character varying(100),
	address_pc character varying(20),
	address_city character varying(20),
	address_status character varying(10),
	modified timestamp with time zone,
	created timestamp with time zone,
	Constraint waddresses_pkey Primary Key (addressid)
)'
  ],
  'wflowstatus' => [
    'CREATE TABLE wflowstatus (
	flow_id integer NOT NULL,
	flowstatus character varying(10) NOT NULL,
	statusdate timestamp with time zone NOT NULL,
	Constraint wflowstatus_pkey Primary Key (flow_id)
)'
  ],
  'sessions_seq' => [
    'CREATE SEQUENCE sessions_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1 '
  ],
  'wflowsstatus' => [
    'CREATE TABLE wflowsstatus (
	object_id integer NOT NULL,
	rt_status character varying(20) NOT NULL,
	status_date timestamp with time zone DEFAULT now() NOT NULL,
	sched_id character varying(20),
	system_pid character varying(50),
	next_exectime timestamp with time zone,
	Constraint wflowsstatus_pkey Primary Key (object_id)
)'
  ],
  'cafusers' => [
    'CREATE TABLE cafusers (
	userid character varying(50) NOT NULL,
	userpass character varying(100) NOT NULL,
	status character varying(20) DEFAULT \'online\' NOT NULL,
	hostsallow character varying(150),
	hostsdeny character varying(150),
	userlabel character varying(100),
	Constraint cafusers_pkey Primary Key (userid)
)'
  ],
  'attributes' => [
    'CREATE TABLE attributes (
	attrdefid character varying(20) NOT NULL,
	object_id integer NOT NULL,
	attrvalue character varying(50) NOT NULL,
	Constraint attributs_pkey Primary Key (attrdefid, object_id)
)'
  ],
  'wrunhisto' => [
    'CREATE TABLE wrunhisto (
	run_id integer NOT NULL,
	object_id integer NOT NULL,
	syspid character varying(50) NOT NULL,
	started timestamp with time zone NOT NULL,
	duration integer,
	onerror character varying(3) DEFAULT \'no\',
	incoms integer,
	transforms integer,
	outgos integer,
	rollbaks integer,
	Constraint wrunhisto_pkey Primary Key (run_id, object_id)
)',
    'CREATE  INDEX wrunhisto_object_id_key on wrunhisto using btree ( object_id int4_ops )',
    'CREATE  INDEX wrunhisto_started_key on wrunhisto using btree ( started timestamp_ops )'
  ],
  'waddresslist' => [
    'CREATE TABLE waddresslist (
	groupid character varying(30) NOT NULL,
	addressid character varying(30) NOT NULL,
	member_status character varying(10) DEFAULT \'enabled\',
	Constraint waddresslist_pkey Primary Key (addressid, groupid)
)'
  ],
  'objects_seq' => [
    'CREATE SEQUENCE objects_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1 '
  ],
  'users' => [
    'CREATE TABLE users (
	object_id integer NOT NULL,
	username character varying(50) NOT NULL,
	password character varying(50),
	Constraint users_pkey Primary Key (object_id)
)',
    'CREATE  INDEX users_username_key on users using btree ( username varchar_ops )'
  ],
  'wrunerrors_seq' => [
    'CREATE SEQUENCE wrunerrors_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1 '
  ],
  'envvars' => [
    'CREATE TABLE envvars (
	object_id bigint NOT NULL,
	varname character varying(50) NOT NULL,
	varvalue character varying(250),
	vartype character varying(10) DEFAULT \'env\',
	Constraint envvars_pkey Primary Key (object_id, varname)
)'
  ],
  'dbtype' => [
    'CREATE TABLE dbtype (
	dbtype character varying(20) NOT NULL,
	refdb character varying(20) NOT NULL,
	Constraint dbtype_pkey Primary Key (dbtype)
)'
  ],
  'objects' => [
    'CREATE TABLE objects (
	id integer NOT NULL,
	type character varying(20) NOT NULL,
	name character varying(50) NOT NULL,
	parent_id integer DEFAULT -1 NOT NULL,
	created timestamp with time zone DEFAULT now() NOT NULL,
	modified timestamp with time zone DEFAULT now() NOT NULL,
	deleted timestamp with time zone,
	comments character varying(255),
	status character varying(20) DEFAULT \'online\',
	createdby character varying(50),
	modifiedby character varying(50),
	objectlabel character varying(100),
	Constraint objects_pkey Primary Key (id)
)',
    'CREATE  INDEX createdby_objects_key on objects using btree ( createdby varchar_ops )',
    'CREATE  INDEX objectlabel_objects_key on objects using btree ( objectlabel varchar_ops )',
    'CREATE UNIQUE INDEX objects_ukey1 on objects using btree ( name varchar_ops, parent_id int4_ops, type varchar_ops )'
  ],
  'context' => [
    'CREATE TABLE context (
	contextid character varying(50) NOT NULL,
	contextlabel character varying(100),
	connector_id integer,
	workdir character varying(150),
	programdir character varying(150),
	ftpconnector_id integer,
	mailconnector_id integer,
	pop3connector_id integer,
	adminmail character varying(100),
	archconnector_id integer,
	archdelay smallint,
	extra1 character varying(250),
	extra2 character varying(250),
	extra3 character varying(250),
	Constraint contexts_pkey Primary Key (contextid)
)'
  ],
  'connector' => [
    'CREATE TABLE connector (
	object_id integer NOT NULL,
	externalname character varying(20),
	userid integer NOT NULL,
	protocolid character varying(20) NOT NULL,
	driverid character varying(20) NOT NULL,
	port character varying(20),
	dbidsn character varying(250),
	ismaster character varying(20) DEFAULT \'MASTER\',
	master_id integer,
	contextid character varying(50),
	proxy_id integer,
	Constraint connector_pkey Primary Key (object_id)
)'
  ],
  'labels' => [
    'CREATE TABLE labels (
	mnemo character varying(30) NOT NULL,
	lang character varying(30) DEFAULT \'en\' NOT NULL,
	label character varying(250) NOT NULL,
	Constraint labels_pkey Primary Key (lang, mnemo)
)'
  ],
  'wevents' => [
    'CREATE TABLE wevents (
	object_id integer NOT NULL,
	eventid character varying(30) NOT NULL,
	eventdate timestamp with time zone DEFAULT now() NOT NULL,
	expiredate timestamp with time zone,
	Constraint wevents_pkey Primary Key (eventid, eventdate, object_id)
)'
  ],
  'wobjectobjects' => [
    'CREATE TABLE wobjectobjects (
	owner_id integer NOT NULL,
	owned_id integer NOT NULL,
	Constraint wobjectobjects_pkey Primary Key (owned_id, owner_id)
)'
  ],
  'imports' => [
    'CREATE TABLE imports (
   contextid varchar(20) NOT NULL,
   external_id int8 NOT NULL,
   local_id int8 NOT NULL,
   first_imported timestamp DEFAULT now() NOT NULL,
   last_imported timestamp DEFAULT now() NOT NULL,
   last_modified timestamp,
   CONSTRAINT imports_pkey PRIMARY KEY (contextid, external_id)
)',
    'CREATE  INDEX imports_contextid_key ON imports (contextid)',
    'CREATE  INDEX imports_local_id_key ON imports (local_id)'
  ],
  'container' => [
    'CREATE TABLE container (
	object_id integer NOT NULL,
	externalname character varying(50),
	flowdirection character varying(20) DEFAULT \'inout\' NOT NULL,
	rollbackspace character varying(3) DEFAULT \'no\',
	xcreate character varying(3) DEFAULT \'no\',
	externalschema character varying(50),
	externaltype character varying(50),
	compressmeth character varying(20),
	cryptmeth_id integer,
	Constraint container_pkey Primary Key (object_id)
)'
  ],
  'attrdef' => [
    'CREATE TABLE attrdef (
	attrdefid character varying(20) NOT NULL,
	protocolid character varying(50) DEFAULT \'all\' NOT NULL,
	driverid character varying(50) DEFAULT \'all\' NOT NULL,
	objtype character varying(20) NOT NULL,
	datatype character varying(20) DEFAULT \'char\' NOT NULL,
	attrdeflabel character varying(50),
	attrdefault character varying,
	requiredattr character varying(10) DEFAULT \'no\',
	Constraint attrdef_pkey Primary Key (attrdefid, driverid, protocolid)
)',
    'CREATE  INDEX attrdefid_attrdef_key on attrdef using btree ( attrdefid varchar_ops )',
    'CREATE  INDEX attrdeflabel_attrdef_key on attrdef using btree ( attrdeflabel varchar_ops )'
  ],
  'sessions' => [
    'CREATE TABLE sessions (
	sessionid character varying(100) NOT NULL,
	connecttime timestamp with time zone DEFAULT now() NOT NULL,
	ipaddress character varying(50) NOT NULL,
	lastaccess timestamp with time zone DEFAULT now(),
	vars character varying,
	userid character varying(50),
	Constraint sessions_pkey Primary Key (sessionid)
)'
  ],
  'wrunning' => [
    'CREATE TABLE wrunning (
	run_id integer NOT NULL,
	object_id integer NOT NULL,
	syspid character varying(50) NOT NULL,
	started timestamp with time zone NOT NULL,
	finished timestamp with time zone,
	onerror character varying(3) DEFAULT \'no\',
	Constraint wrunning_pkey Primary Key (run_id)
)',
    'CREATE  INDEX wrunning_object_id_key on wrunning using btree ( object_id int4_ops )',
    'CREATE  INDEX wrunning_started_key on wrunning using btree ( started timestamp_ops )'
  ],
  'dataformat' => [
    'CREATE TABLE dataformat (
	stdtypeid character varying(20) NOT NULL,
	dataformat character varying(20) NOT NULL,
	Constraint dataformat_pkey Primary Key (dataformat, stdtypeid)
)'
  ],
  'driver' => [
    'CREATE TABLE driver (
	driverid character varying(20) NOT NULL,
	protocolid character varying(10) NOT NULL,
	driverlabel character varying(50),
	cantransact character varying(10) DEFAULT \'no\',
	Constraint driver_pkey Primary Key (driverid, protocolid)
)'
  ],
  'datatype' => [
    'CREATE TABLE datatype (
	stdname character varying(20) NOT NULL,
	driverid character varying(20) NOT NULL,
	datatypeid character varying(20) NOT NULL,
	Constraint datatype_pkey Primary Key (datatypeid, driverid, stdname)
)',
    'CREATE  INDEX datatypeid_datatype_key on datatype using btree ( datatypeid varchar_ops )',
    'CREATE  INDEX driverid_datatype_key on datatype using btree ( driverid varchar_ops )',
    'CREATE  INDEX stdname_datatype_key on datatype using btree ( stdname varchar_ops )'
  ]
};
my $sqlDropObjects = {
  'protocol' => 'DROP TABLE protocol',
  'wwaitevents' => 'DROP TABLE wwaitevents',
  'mapping' => 'DROP TABLE mapping',
  'subflow' => 'DROP TABLE subflow',
  'scriptobject' => 'DROP TABLE scriptobject',
  'pscripts' => 'DROP TABLE pscripts',
  'wvars' => 'DROP TABLE wvars',
  'cafproxy' => 'DROP TABLE cafproxy',
  'flow' => 'DROP TABLE flow',
  'deployedobjects' => 'DROP TABLE deployedobjects',
  'server' => 'DROP TABLE server',
  'scripts' => 'DROP TABLE scripts',
  'objectevents' => 'DROP TABLE objectevents',
  'field' => 'DROP TABLE field',
  'wscheduler' => 'DROP TABLE wscheduler',
  'wrunerrors' => 'DROP TABLE wrunerrors',
  'otherobjects' => 'DROP TABLE otherobjects',
  'wrunhisto_seq' => 'DROP SEQUENCE wrunhisto_seq',
  'waddresses' => 'DROP TABLE waddresses',
  'wflowstatus' => 'DROP TABLE wflowstatus',
  'sessions_seq' => 'DROP SEQUENCE sessions_seq',
  'wflowsstatus' => 'DROP TABLE wflowsstatus',
  'cafusers' => 'DROP TABLE cafusers',
  'attributes' => 'DROP TABLE attributes',
  'wrunhisto' => 'DROP TABLE wrunhisto',
  'waddresslist' => 'DROP TABLE waddresslist',
  'objects_seq' => 'DROP SEQUENCE objects_seq',
  'users' => 'DROP TABLE users',
  'wrunerrors_seq' => 'DROP SEQUENCE wrunerrors_seq',
  'envvars' => 'DROP TABLE envvars',
  'dbtype' => 'DROP TABLE dbtype',
  'objects' => 'DROP TABLE objects',
  'context' => 'DROP TABLE context',
  'connector' => 'DROP TABLE connector',
  'labels' => 'DROP TABLE labels',
  'wevents' => 'DROP TABLE wevents',
  'wobjectobjects' => 'DROP TABLE wobjectobjects',
  'imports' => 'DROP TABLE imports',
  'container' => 'DROP TABLE container',
  'attrdef' => 'DROP TABLE attrdef',
  'sessions' => 'DROP TABLE sessions',
  'wrunning' => 'DROP TABLE wrunning',
  'dataformat' => 'DROP TABLE dataformat',
  'driver' => 'DROP TABLE driver',
  'datatype' => 'DROP TABLE datatype'
};
my $sqlData = {
  'wscheduler' => [
    'INSERT INTO "wscheduler" ("sched_id","sched_label","object_id","sched_created","sched_modified","sched_min","sched_hour","sched_mday","sched_month","sched_wday","sched_mode","sched_status","tracefile","errorfile","sched_secs") VALUES (\'archiver\',\'Archivage et Optimisation\',-1, now(), now(),\'0\',\'0\',\'*\',\'*\',\'0\',\'daemon\',\'offline\',NULL,NULL,NULL)',
    'INSERT INTO "wscheduler" ("sched_id","sched_label","object_id","sched_created","sched_modified","sched_min","sched_hour","sched_mday","sched_month","sched_wday","sched_mode","sched_status","tracefile","errorfile","sched_secs") VALUES (\'monitor\',\'Surveillance des jobs\',-1, now(), now(),\'0-59/5\',\'0-23\',\'*\',\'*\',\'0-6\',\'daemon\',\'online\',NULL,NULL,NULL)'
  ],
  'protocol' => [
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'DBI\',\'DBI connector\',\'inout\')',
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'FTP\',\'FTP connectors\',\'inout\')',
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'HTTP\',\'HTTP connector\',\'incom\')',
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'LDAP\',\'LDAP connector\',\'inout\')',
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'LFS\',\'Local file system\',\'inout\')',
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'POP3\',\'POP3 connector\',\'inout\')',
    'INSERT INTO "protocol" ("protocolid","protocollabel","inoutdir") VALUES (\'SMTP\',\'SMTP connector\',\'outgo\')'
  ],
  'context' => [
    'INSERT INTO "context" ("contextid","contextlabel","connector_id","workdir","programdir","ftpconnector_id","mailconnector_id","pop3connector_id","adminmail","archconnector_id","archdelay","extra1","extra2","extra3") VALUES (\'default\',\'default context\',-1,\'/path/to/working/directory\',\'/path/to/cafeterra\', -1,-1,-1,\'Your.Administator@Mail.Address\',-1,7,NULL,NULL,NULL)'
  ],
  'cafusers' => [
    'INSERT INTO "cafusers" ("userid","userpass","status","hostsallow","hostsdeny","userlabel") VALUES (\'aliphe\',\'aliphe\',\'online\',\'localhost;*\',NULL,\'Cafeterra Administrator\')'
  ],
  'attrdef' => [
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'ORACLE_HOME\',\'DBI\',\'Oracle\',\'connector\',\'string\',\'Oracle Home\',\'--nodefault--\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'FIELD_SEP\',\'all\',\'CSV\',\'connector\',\'string\',\'Field separator\',\';\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'RECORD_SEP\',\'all\',\'CSV\',\'connector\',\'string\',\'Record separator\',\'\\\\n\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'ESCAPE_CHAR\',\'all\',\'CSV\',\'connector\',\'string\',\'Escape character\',\'\\\\\\\\\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'QUOTE_CHAR\',\'all\',\'CSV\',\'connector\',\'string\',\'Field delimiter\',\'"\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'DIRECTORY\',\'LFS\',\'all\',\'connector\',\'string\',\'Directory\',\'\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'DIRECTORY\',\'FTP\',\'all\',\'connector\',\'string\',\'Directory\',\'\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'COLUMN_NAMES\',\'all\',\'CSV\',\'connector\',\'list\',\'Column names in first row\',\'no;yes;no\',NULL)',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'AutoCommit\',\'DBI\',\'all\',\'connector\',\'number\',\'Autocommit\',\'0\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'RaiseError\',\'DBI\',\'all\',\'connector\',\'number\',\'RaiseError\',\'1\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'PrintError\',\'DBI\',\'all\',\'connector\',\'number\',\'PrintError\',\'0\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'RECORD_TAG\',\'all\',\'XML\',\'container\',\'string\',\'Recod tab\',\'\',\'\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'SHEETNAME\',\'all\',\'XCEL\',\'container\',\'atome\',\'Sheet Name\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'STARTCOL\',\'all\',\'XCEL\',\'container\',\'atome\',\'First Column\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'COLCOUNT\',\'all\',\'XCEL\',\'container\',\'atome\',\'Columns Count\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'STARTROW\',\'all\',\'XCEL\',\'container\',\'atome\',\'First Row\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'ROWSCOUNT\',\'all\',\'XCEL\',\'container\',\'atome\',\'Rows Count\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'FILENAME\',\'all\',\'XCEL\',\'connector\',\'atome\',\'File Name\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'TITLESROW\',\'all\',\'XCEL\',\'container\',\'atome\',\'Titles Row\',\'\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_ACCEPT_FROM\',\'all\',\'all\',\'webservice\',\'string\',\'Webservice Allowed Hosts\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_INTERFACE\',\'all\',\'all\',\'webservice\',\'string\',\'Webservice Listen Interface\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_PORT\',\'all\',\'all\',\'webservice\',\'number\',\'Webservice Port\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_TYPE\',\'all\',\'all\',\'webservice\',\'list\',\'Webservice Type\',\'WS_SOAP;WS_SOAP;WS_XMLRPC\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_COMPRESSION\',\'all\',\'all\',\'webservice\',\'number\',\'Webservice Compression threshold\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_HTTPS_CERT_FILE\',\'all\',\'all\',\'webservice\',\'string\',\'Webservice SSL certificat file\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_HTTPS_KEY_FILE\',\'all\',\'all\',\'webservice\',\'string\',\'Webservice SSL key file\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_AUTHTYPE\',\'all\',\'all\',\'webservice\',\'list\',\'Webservice Authentification methode\',\'WS_AUTH_NONE;WS_AUTH_NONE;WS_AUTH_TICKET\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_AUTH_TTL\',\'all\',\'all\',\'webservice\',\'number\',\'Webservice Auth. Time To Live in seconds\',\'60\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_PROTOCOL\',\'all\',\'all\',\'webservice\',\'list\',\'Webservice Protocol\',\'WS_PROTO_HTTP;WS_PROTO_HTTP;WS_PROTO_TCP;WS_PROTO_POP3\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'WS_REUSEPORT\',\'all\',\'all\',\'webservice\',\'list\',\'Webservice Reuse Port\',\'0\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'HPRIM_MAINSEP\',\'all\',\'HPRIM\',\'connector\',\'atome\',\'Hprim main separator\',\'|\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'HPRIM_SUBSUBFIELDSEP\',\'all\',\'HPRIM\',\'connector\',\'atome\',\'Hprim separator for sub sub fields\',\'&\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'HPRIM_SUBFIELDSEP\',\'all\',\'HPRIM\',\'connector\',\'atome\',\'Hprim separator for sub fields\',\'~\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'HPRIM_REPEATER\',\'all\',\'HPRIM\',\'connector\',\'atome\',\'Hprim separator for repeated fields\',\'^\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'HPRIM_ESCAPECHAR\',\'all\',\'HPRIM\',\'connector\',\'atome\',\'Hprim escape char\',\'\\\\\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_ROOTDN\',\'LDAP\',\'LDAP\',\'connector\',\'atome\',\'Ldap root dn\',NULL,\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_BASEDN\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Base dn for the container\',NULL,\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_BASEFILTER\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Base filter for the container\',\'(objectclass=*)\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_DNATTRS\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Default attributes to create DNs for new entries\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_INSERTATTRS\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Default attributes values for new entries\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_SIZELIMIT\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Number of entries fetched by a query\',\'0\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_TIMELIMIT\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Max duration of a query\',\'0\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_INSEPARATOR\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Sep for multiples values when inserting\',NULL,\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_OUTSEPARATOR\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'Sep for multiples values when fetching\',NULL,\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_FIRSTONLY\',\'LDAP\',\'LDAP\',\'container\',\'atome\',\'For multiples retrieve first one only\',NULL,\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_SCOPE\',\'LDAP\',\'LDAP\',\'container\',\'list\',\'Scope of the search\',\'sub;sub;base;one\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'AutoCommit\',\'LDAP\',\'LDAP\',\'connector\',\'number\',\'Autocommit\',\'1\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'LDAP_LOGINRULE\',\'LDAP\',\'LDAP\',\'connector\',\'atome\',\'Ldap loginrule (eg cn=*,<ROOT>)\',\'cn=*,<ROOT>\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_CHILDCOUNT\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Max number of childs\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_CHILDPORT\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Child port number\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_CLIENTPORT\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Client port number\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_HOSTALLOW\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Hosts allowed to connect\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_HOSTDENY\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Hosts not allowd to connect\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_MAXCHILDMSGSIZE\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Max size of messages from child\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_MAXCLIENTMSGSIZE\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Max size of messages from client\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_MAXMSGSIZE\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Max message size\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_RECSEP\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Record separator (see xmlsocket doc)\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_REUSE\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Reuse port\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid", "protocolid", "driverid", "objtype", "datatype", "attrdeflabel", "attrdefault", "requiredattr") VALUES (\'XS_SCRIPTTO\',\'all\',\'all\',\'xmlsocket\',\'list\',\'Script timeout\',\'--nodefault--\',\'no\')',
    'INSERT INTO "attrdef" ("attrdefid","protocolid","driverid","objtype","datatype","attrdeflabel","attrdefault","requiredattr") VALUES (\'GENERIC_OTHERS\',\'DBI\',\'Generic\',\'connector\',\'string\',\'Additional dbi attributes eg : {ATT => VAL}\',\'--nodefault--\',\'no\')'
  ],
  'driver' => [
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'CSV\',\'FTP\',\'CSV driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'CSV\',\'HTTP\',\'CSV driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'CSV\',\'LFS\',\'CSV driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'CSV\',\'POP3\',\'CSV driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'CSV\',\'SMTP\',\'CSV driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XML\',\'FTP\',\'Simple XML files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XML\',\'HTTP\',\'Simple XML files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XML\',\'LFS\',\'Simple XML files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XML\',\'POP3\',\'Simple XML files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XML\',\'SMTP\',\'Simple XML files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HTML\',\'FTP\',\'Simple HTML Table\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HTML\',\'HTTP\',\'Simple HTML Table\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HTML\',\'LFS\',\'Simple HTML Table\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HTML\',\'POP3\',\'Simple HTML Table\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HTML\',\'SMTP\',\'Simple HTML Table\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'FLR\',\'FTP\',\'FFL files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'FLR\',\'HTTP\',\'FFL files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'FLR\',\'LFS\',\'FFL files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'FLR\',\'POP3\',\'FFL files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'FLR\',\'SMTP\',\'FFL files\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XCEL\',\'FTP\',\'Simple Excel Sheet driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XCEL\',\'HTTP\',\'Simple Excel Sheet driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XCEL\',\'LFS\',\'Simple Excel Sheet driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XCEL\',\'POP3\',\'Simple Excel Sheet driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'XCEL\',\'SMTP\',\'Simple Excel Sheet driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'LDAPD\',\'LDAP\',\'Simple LDAP driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'mySql\',\'DBI\',\'mySql driver\',NULL)',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'Oracle\',\'DBI\',\'Oracle driver\',\'yes\')',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'Pg\',\'DBI\',\'Postgress Driver\',\'yes\')',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'Generic\',\'DBI\',\'Generic DBI Driver\',\'yes\')',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'DIRSL\',\'FTP\',\'Directory listing\',\'\')',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'DIRSL\',\'LFS\',\'Directory listing\',\'\')',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HPRIM\',\'FTP\',\'HPRIM Driver\',\'\')',
    'INSERT INTO "driver" ("driverid","protocolid","driverlabel","cantransact") VALUES (\'HPRIM\',\'LFS\',\'HPRIM Driver\',\'\')'
  ],
  'datatype' => [
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'Oracle\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DECIMAL\',\'Oracle\',\'NUMBER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARBINARY\',\'Oracle\',\'RAW\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DOUBLE\',\'Oracle\',\'DOUBLE\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'Oracle\',\'DATE\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'Oracle\',\'LONG\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'Oracle\',\'VARCHAR2\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'Oracle\',\'LONG_RAW\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'Pg\',\'BPCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'Pg\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'Pg\',\'TIMESPAN\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIME\',\'Pg\',\'TIMESTAMP\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DATE\',\'Pg\',\'DATE\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_ALL_TYPES\',\'Pg\',\'BOOL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_FLOAT\',\'Pg\',\'FLOAT4\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'Pg\',\'FLOAT8\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIME\',\'Pg\',\'ABSTIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'Pg\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_SMALLINT\',\'Pg\',\'INT2\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'Pg\',\'INT4\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIME\',\'Pg\',\'RELTIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIME\',\'Pg\',\'TIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'Pg\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_ALL_TYPES\',\'Pg\',\'MONEY\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DOUBLE\',\'Pg\',\'INT8\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'Pg\',\'TINTERVAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'==standardsql==\',\'-1\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_BINARY\',\'==standardsql==\',\'-2\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARBINARY\',\'==standardsql==\',\'-3\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'==standardsql==\',\'-4\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_ALL_TYPES\',\'==standardsql==\',\'0\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_BIGINT\',\'==standardsql==\',\'-5\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'==standardsql==\',\'1\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TINYINT\',\'==standardsql==\',\'-6\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_NUMERIC\',\'==standardsql==\',\'2\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_BIT\',\'==standardsql==\',\'-7\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DECIMAL\',\'==standardsql==\',\'3\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_WCHAR\',\'==standardsql==\',\'-8\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'==standardsql==\',\'4\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIME\',\'==standardsql==\',\'10\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_WVARCHAR\',\'==standardsql==\',\'-9\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_SMALLINT\',\'==standardsql==\',\'5\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'==standardsql==\',\'11\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_FLOAT\',\'==standardsql==\',\'6\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'==standardsql==\',\'12\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'==standardsql==\',\'7\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DOUBLE\',\'==standardsql==\',\'8\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DATE\',\'==standardsql==\',\'9\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_WLONGVARCHAR\',\'==standardsql==\',\'-10\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'CSV\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'CSV\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'CSV\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'CSV\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'CSV\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'CSV\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'CSV\',\'REAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'FLR\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'FLR\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'FLR\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'FLR\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'FLR\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'FLR\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'FLR\',\'REAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'HTML\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'HTML\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'HTML\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'HTML\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'HTML\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'HTML\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'HTML\',\'REAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'mySql\',\'MIDDLEINT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'mySql\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'mySql\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_SMALLINT\',\'mySql\',\'SMALLINT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'mySql\',\'TIMESTAMP\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DOUBLE\',\'mySql\',\'DOUBLE\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DATE\',\'mySql\',\'DATE\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TINYINT\',\'mySql\',\'TINYINT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'mySql\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_BIGINT\',\'mySql\',\'BIGINT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'mySql\',\'TINYBLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'mySql\',\'MEDIUMBLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_SMALLINT\',\'mySql\',\'YEAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_DECIMAL\',\'mySql\',\'DECIMAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIME\',\'mySql\',\'TIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'mySql\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'mySql\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'mySql\',\'FLOAT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'mySql\',\'LONGBLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'mySql\',\'ENUM\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'mySql\',\'SET\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'XML\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'XML\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'XML\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'XML\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'XML\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'XML\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'XML\',\'REAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'XCEL\',\'REAL\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'XCEL\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'XCEL\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'XCEL\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'XCEL\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'XCEL\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'XCEL\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'DIRSL\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'DIRSL\',\'NUMBER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_CHAR\',\'HPRIM\',\'CHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_VARCHAR\',\'HPRIM\',\'VARCHAR\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_TIMESTAMP\',\'HPRIM\',\'DATETIME\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARBINARY\',\'HPRIM\',\'BLOB\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_INTEGER\',\'HPRIM\',\'INTEGER\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_LONGVARCHAR\',\'HPRIM\',\'TEXT\')',
    'INSERT INTO "datatype" ("stdname","driverid","datatypeid") VALUES (\'SQL_REAL\',\'HPRIM\',\'REAL\')'
  ]
};
my $indexes = {
  'wscheduler' => {
    'wscheduler_object_id_key' => 'CREATE  INDEX wscheduler_object_id_key on wscheduler using btree ( object_id int4_ops )',
    'wscheduler_sched_status_key' => 'CREATE  INDEX wscheduler_sched_status_key on wscheduler using btree ( sched_status varchar_ops )'
  },
  'wrunhisto' => {
    'wrunhisto_started_key' => 'CREATE  INDEX wrunhisto_started_key on wrunhisto using btree ( started timestamp_ops )',
    'wrunhisto_object_id_key' => 'CREATE  INDEX wrunhisto_object_id_key on wrunhisto using btree ( object_id int4_ops )'
  },
  'subflow' => {
    'subflow_ukey1' => 'CREATE UNIQUE INDEX subflow_ukey1 on subflow using btree ( container_id int4_ops, flow_id int4_ops, flowdirection varchar_ops, floworder int2_ops )'
  },
  'imports' => {
    'imports_contextid_key' => 'CREATE  INDEX imports_contextid_key ON imports (contextid)',
    'imports_local_id_key' => 'CREATE  INDEX imports_local_id_key ON imports (local_id)'
  },
  'users' => {
    'users_username_key' => 'CREATE  INDEX users_username_key on users using btree ( username varchar_ops )'
  },
  'attrdef' => {
    'attrdeflabel_attrdef_key' => 'CREATE  INDEX attrdeflabel_attrdef_key on attrdef using btree ( attrdeflabel varchar_ops )',
    'attrdefid_attrdef_key' => 'CREATE  INDEX attrdefid_attrdef_key on attrdef using btree ( attrdefid varchar_ops )'
  },
  'wrunning' => {
    'wrunning_started_key' => 'CREATE  INDEX wrunning_started_key on wrunning using btree ( started timestamp_ops )',
    'wrunning_object_id_key' => 'CREATE  INDEX wrunning_object_id_key on wrunning using btree ( object_id int4_ops )'
  },
  'objects' => {
    'createdby_objects_key' => 'CREATE  INDEX createdby_objects_key on objects using btree ( createdby varchar_ops )',
    'objects_ukey1' => 'CREATE UNIQUE INDEX objects_ukey1 on objects using btree ( name varchar_ops, parent_id int4_ops, type varchar_ops )',
    'objectlabel_objects_key' => 'CREATE  INDEX objectlabel_objects_key on objects using btree ( objectlabel varchar_ops )'
  },
  'objectevents' => {
    'objectevents_object_id_key' => 'CREATE UNIQUE INDEX objectevents_object_id_key on objectevents using btree ( eventid varchar_ops, genorwait varchar_ops, object_id int4_ops, object_id_source int4_ops )'
  },
  'datatype' => {
    'driverid_datatype_key' => 'CREATE  INDEX driverid_datatype_key on datatype using btree ( driverid varchar_ops )',
    'stdname_datatype_key' => 'CREATE  INDEX stdname_datatype_key on datatype using btree ( stdname varchar_ops )',
    'datatypeid_datatype_key' => 'CREATE  INDEX datatypeid_datatype_key on datatype using btree ( datatypeid varchar_ops )'
  }
};
my $dropIndexes = {
  'wscheduler' => {
    'wscheduler_object_id_key' => 'DROP INDEX SEQUENCE wscheduler_object_id_key',
    'wscheduler_sched_status_key' => 'DROP INDEX SEQUENCE wscheduler_sched_status_key'
  },
  'wrunhisto' => {
    'wrunhisto_started_key' => 'DROP INDEX SEQUENCE wrunhisto_started_key',
    'wrunhisto_object_id_key' => 'DROP INDEX SEQUENCE wrunhisto_object_id_key'
  },
  'subflow' => {
    'subflow_ukey1' => 'DROP UNIQUE INDEX SEQUENCE subflow_ukey1'
  },
  'imports' => {
    'imports_contextid_key' => 'DROP INDEX SEQUENCE imports_contextid_key',
    'imports_local_id_key' => 'DROP INDEX SEQUENCE imports_local_id_key'
  },
  'users' => {
    'users_username_key' => 'DROP INDEX SEQUENCE users_username_key'
  },
  'attrdef' => {
    'attrdeflabel_attrdef_key' => 'DROP INDEX SEQUENCE attrdeflabel_attrdef_key',
    'attrdefid_attrdef_key' => 'DROP INDEX SEQUENCE attrdefid_attrdef_key'
  },
  'wrunning' => {
    'wrunning_started_key' => 'DROP INDEX SEQUENCE wrunning_started_key',
    'wrunning_object_id_key' => 'DROP INDEX SEQUENCE wrunning_object_id_key'
  },
  'objects' => {
    'createdby_objects_key' => 'DROP INDEX SEQUENCE createdby_objects_key',
    'objects_ukey1' => 'DROP UNIQUE INDEX SEQUENCE objects_ukey1',
    'objectlabel_objects_key' => 'DROP INDEX SEQUENCE objectlabel_objects_key'
  },
  'objectevents' => {
    'objectevents_object_id_key' => 'DROP UNIQUE INDEX SEQUENCE objectevents_object_id_key'
  },
  'datatype' => {
    'driverid_datatype_key' => 'DROP INDEX SEQUENCE driverid_datatype_key',
    'stdname_datatype_key' => 'DROP INDEX SEQUENCE stdname_datatype_key',
    'datatypeid_datatype_key' => 'DROP INDEX SEQUENCE datatypeid_datatype_key'
  }
};
my $repObjects = {
  'protocol' => 1,
  'mapping' => 1,
  'subflow' => 1,
  'objects_seq' => 1,
  'users' => 1,
  'scriptobject' => 1,
  'pscripts' => 1,
  'envvars' => 1,
  'cafproxy' => 1,
  'objects' => 1,
  'dbtype' => 1,
  'flow' => 1,
  'deployedobjects' => 1,
  'context' => 1,
  'server' => 1,
  'scripts' => 1,
  'objectevents' => 1,
  'connector' => 1,
  'labels' => 1,
  'field' => 1,
  'imports' => 1,
  'otherobjects' => 1,
  'attrdef' => 1,
  'container' => 1,
  'sessions' => 1,
  'sessions_seq' => 1,
  'dataformat' => 1,
  'cafusers' => 1,
  'attributes' => 1,
  'datatype' => 1,
  'driver' => 1
};
my $queueObjects = {
  'protocol' => 1,
  'wwaitevents' => 1,
  'mapping' => 1,
  'subflow' => 1,
  'scriptobject' => 1,
  'pscripts' => 1,
  'wvars' => 1,
  'cafproxy' => 1,
  'flow' => 1,
  'deployedobjects' => 1,
  'server' => 1,
  'scripts' => 1,
  'objectevents' => 1,
  'field' => 1,
  'wscheduler' => 1,
  'wrunerrors' => 1,
  'otherobjects' => 1,
  'wrunhisto_seq' => 1,
  'waddresses' => 1,
  'wflowstatus' => 1,
  'sessions_seq' => 1,
  'wflowsstatus' => 1,
  'cafusers' => 1,
  'attributes' => 1,
  'wrunhisto' => 1,
  'waddresslist' => 1,
  'users' => 1,
  'wrunerrors_seq' => 1,
  'envvars' => 1,
  'dbtype' => 1,
  'objects' => 1,
  'context' => 1,
  'connector' => 1,
  'labels' => 1,
  'wevents' => 1,
  'wobjectobjects' => 1,
  'container' => 1,
  'attrdef' => 1,
  'sessions' => 1,
  'wrunning' => 1,
  'dataformat' => 1,
  'driver' => 1,
  'datatype' => 1
};
sub new { bless {}, "sqlscript"; }

sub SqlData { return $sqlData }

sub SqlObjects { return $sqlObjects }

sub SqlDropObjects { return $sqlDropObjects }

sub RepObjects { return $repObjects }

sub QueueObjects { return $queueObjects }

sub Indexes { return $indexes }

sub DropIndexes { return $dropIndexes }

1;
