#!/usr/local/bin/perl
#
# cafpSMTP 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;


package cafpSMTP;

use Mail::Sender;
use connectors::cafProto;
use Cwd;
use Mail::Sender;
use File::Basename;
use File::Spec;
use Data::Dumper;
@cafpSMTP::ISA = ("cafProto");
use strict;


sub _init {
	my $self = shift;

	$self->connected();
}


sub connected {
	my $self = shift;
	my $class = ref($self);

	my $smtph = $self->{_SMTPH};

	return $self if($smtph);

	my $db = $self->{db};

	my %attrs;
	unless ($smtph) {

		my $server = $db->{server}{host_name} ||  $db->{server}{host_address};

=over
		%attrs = (
			#Port        => $db->{server}{port} || undef,
			from        => $db->{_ATTRS}{SMTP_FROM} || "flow.Cafeterra.net",
			fake_from   => $db->{_ATTRS}{SMTP_FAKEFROM} || "Cafeterra",
			to          => $db->{_ATTRS}{SMTP_TO},
			replay_to   => $db->{_ATTRS}{SMTP_REPLAYTO} || "Noreplay.please",
			fake_to     => $db->{_ATTRS}{SMTP_FAKETO}|| "Please do not replay to this addresse",
			cc          => $db->{_ATTRS}{SMTP_CC},
			fake_cc     => $db->{_ATTRS}{SMTP_FAKECC},
			bcc         => $db->{_ATTRS}{SMTP_BCC},
			smtp        => $server,
			subject     => $db->{_ATTRS}{SMTP_SUBJECT},
			headers     => $db->{_ATTRS}{SMTP_HEADERS},
			boundary    => $db->{_ATTRS}{SMTP_BOUNDARY} || "1234567----Cafeterra-----09876",
			client      => $db->{_ATTRS}{SMTP_CLIENT},
			encoding    => $db->{_ATTRS}{SMTP_ENCODING},
			charset     => $db->{_ATTRS}{SMTP_CHARSET} || "ASCII",
			type        => $db->{_ATTRS}{SMTP_TYPE},
			ctype       => $db->{_ATTRS}{SMTP_CTYPE} || "text/plain",
		);
=cut
		my $smtph = Mail::Sender->new (smtp => $server);
		$self->{_SMTPH} = $smtph;
	}

	return $self;
}

sub getfile {
	my $self = shift;
	my $filedesc = shift;

	my $class = ref($self);

	my $fname = $filedesc->{fname};
	my $dir = $filedesc->{dir} || $self->_dir();
	my $mode = $filedesc->{mode};

	my ($fh, $tempf);

	if (($mode eq 'w') || ($mode eq "u")) {
		$tempf = $self->gettemporaryfile(".smtp", undef, undef, "smtp");
	}
	else { die "$class openfile : unsupported mode ($mode)"; }
}

sub listtables {
	my $self = shift;
	my $dir = shift || $self->_dir();
	my $pattern = shift;
 
	return undef;
}


sub savemessage {
	my $self = shift;
	my $dir = shift;
	my $tempf = shift;

	my $diederror;


	my $id = $self->{db}{connector}{object_id};
	my $filepat = 'header\.$id\.([[:digit:]]*)\.smtp';
	my @files;
	if (open (D, $dir)) {
		@files = grep { /$filepat/ } readdir(D);
		my $index = 0;
		foreach my $file (@files) {
			if ($file =~ /$filepat/) {
				$index = $1 if ($index > $1);
			}
		}
		if ($tempf) {
			$index += 1;
			my $headerf = $File::Spec->catfile($dir, "header.$id.$index.smtp");
			my $bodyf = $File::Spec->catfile($dir, "body.$id.$index.smtp");
			if (rename ($tempf, $bodyf)) {
	
				my $dump = Data::Dumper->new([$self->{db}{_ATTRS}], ["smtpattrs"]);
				if (open (O, ">", $headerf)) {
					push @files, "header.$id.$index.smtp";
					print O $dump->Dump();
					close O;
				}
				else { $diederror = "Enable to write message file header.$id.$index.smtp"; }
			}
			else { $diederror = "Enable to write message file body.$id.$index.smtp"; }
		}
	}
	else { $diederror = "Unable to open $dir"; }
	
	return ($diederror, \@files);
}
	
sub sendmessage {
	my $self = shift;
	my $smtpattrs = shift;
	my $bodyf = shift;
	$self->connected();
	my $smtph = $self->{_SMTPH};
	my $db = $self->{db};

	my %attrs = (
			from        => $db->{_ATTRS}{SMTP_FROM} || "flow.Cafeterra.net",
			fake_from   => $db->{_ATTRS}{SMTP_FAKEFROM} || "Cafeterra",
			to          => $db->{_ATTRS}{SMTP_TO},
			replay_to   => $db->{_ATTRS}{SMTP_REPLAYTO} || "Noreplay.please",
			fake_to     => $db->{_ATTRS}{SMTP_FAKETO}|| "Please do not replay to this addresse",
			cc          => $db->{_ATTRS}{SMTP_CC},
			fake_cc     => $db->{_ATTRS}{SMTP_FAKECC},
			bcc         => $db->{_ATTRS}{SMTP_BCC},
			subject     => $db->{_ATTRS}{SMTP_SUBJECT},
			headers     => $db->{_ATTRS}{SMTP_HEADERS},
			boundary    => $db->{_ATTRS}{SMTP_BOUNDARY} || "1234567----Cafeterra-----09876",
			client      => $db->{_ATTRS}{SMTP_CLIENT},
			encoding    => $db->{_ATTRS}{SMTP_ENCODING},
			charset     => $db->{_ATTRS}{SMTP_CHARSET} || "ASCII",
			type        => $db->{_ATTRS}{SMTP_TYPE},
			ctype       => $db->{_ATTRS}{SMTP_CTYPE} || "text/plain",
		);
	my $OK;
	if ($smtpattrs->{SMTP_ATTACHED} = "attached") {
		$smtph->OpenMultiPart(\%attrs);
		if ($smtpattrs->{SMTP_INTRO}) { $OK = $smtph->Send($smtph->{SMTP_INTRO}); }
		if ((-f $bodyf) and ($OK)) {
			$OK = $smtph->SendFile({ description => $smtpattrs->{SMTP_DESCRIPTION},
				           disposition => "inline; filename= $smtpattrs->{SMTP_FILENAME}",
				           file => $bodyf});
		}
		elsif ($bodyf) { $OK = $smtph->Send($bodyf); }

		foreach my $attached (@{$smtpattrs->{SMTP_ATTACHEDFILES}||[]}) {
			last unless ($OK);
			my $disposition = $smtpattrs->{ATTACHED_DISPOSITION};
			if (-f $attached->{ATTACHED_FILE}) {
				$OK = $smtph->SendFile({ description => $attached->{ATTACHED_DESCRIPTION},
				           type => $attached->{ATTACHED_TYPE}, encoding => $attached->{ATTACHED_ENCODING},
				           disposition => $disposition || "inline; filename= $smtpattrs->{ATTACHED_FILENAME}",
				           file => $attached->{ATTACHED_FILE}});
			}
		}
	}
	else {
		$smtph->OpenMultiPart(\%attrs);
		if ($smtph->{SMTP_INTRO}) { $OK = $smtph->Send($smtph->{SMTP_INTRO}); }
		open (I, $bodyf);
		my $bodyText;
		{
			local $/;
			undef $/;
			$bodyText = <I>;
		}
		close(I);
		$OK = $self->Send ($bodyText);
	}

	if ($OK) { $smtph->Close(); return 1; }
	else { smtph->Cancel(); return undef; }
}

sub sendmessages {
	my $self = shift;
	my $files = shift;

	foreach my $headerf (@$files) {
		my $smtpattrs;
		my $bodyf = $headerf;
		$bodyf =~ s/^header/body/;
		if ((! -f $headerf) || (! -f $bodyf)) {
			unlink $headerf if (-f $headerf);
			unlink $bodyf if (-f $bodyf);
			next;
		}
		if (open (I, $headerf)) {
			local $/;
			undef $/;
			my $headertxt = <T>;
			close I;
			eval $headertxt;
#			my $attrs = parsesmtpattrs ($smtpattrs);
			if ($self->sendmessage($smtpattrs, $bodyf)) {
				unlink $headerf;
				unlink $bodyf;
				foreach my $attached (@{$smtpattrs->{SMTP_ATTACHEDFILES}||[]}) {
					unlink $attached->{ATTACHED_FILE} if (-f $attached->{ATTACHED_FILE});
				}
			}
		}
	}
}

sub protorollback {
	my $self = shift;
	my $tempf = shift;

	my $dir = File::Basename::dirname($tempf);
	my $cwd = Cwd->getcwd();
	chdir $dir;

	unlink $tempf if (-f $tempf);

	my (undef, $files) = $self->savemessage($dir);

	$self->sendmessages($files);

	chdir $cwd;

	1;
}
	

sub protocommit {
	my $self = shift;
	my $tempf = shift;

	my $dir = File::Basename::dirname($tempf);

	my $cwd = Cwd->getcwd();
	chdir $dir;

	my ($dieerror, $files) = $self->savemessage($dir, $tempf);

	$self->sendmessages($files);
	chdir $cwd;
	die ($dieerror) if ($dieerror);
	1;
}

sub protodisconnect {
	my $self = shift;
	my $class = ref($self);

	return "0E0"
}

sub smtp_server {
	my $self = shift;

	@_ ? $self->{db}->{server}{host_name} = shift : $self->{db}{server}{host_name};
}

sub smtp_intro {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_INTRO} = shift : $self->{db}->{_ATTRS}{SMTP_INTRO};
}

sub smtp_attachfile {
	my $self = shift;
	my $path = shift;
	my $description = shift;
	my $type = shift;
	my $encoding = shift;
	my $disposition = shift;

	my $rioh;
	die ("No file provided") unless ((-f $path) && ($rioh = IO::File->new($path, "r")));
	if ($disposition and ($disposition =~ /filename *=/i)) {
		my $filename = File::Basename::basename($path, "");
		$disposition .= ";filename=$filename";
	}

	my ($wioh, $tempf) = $self->gettemporaryfile(".attached", "fh", 1, "smtp");

	binmode $wioh;
	$wioh->autoflush(1);
	my $in;
 
	my $nreads;
	my $nwrite = 0;
	while ($nreads = $rioh->read($in, 1024)) {
		$nwrite = $wioh->write($in, $nreads);
	}
	close $rioh;
	close $wioh;
	
	my $attached = {
		ATTACHED_DESCRIPTION => $description,
		ATTACHED_TYPE       => $type,
		ATTACHED_ENCODING   => $encoding,
		ATTACHED_DISPOSITION => $disposition,
		ATTACHED_FILE => $tempf,
	};

	return 1;
}

sub smtp_from {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_FROM} = shift : $self->{db}->{_ATTRS}{SMTP_FROM};
}

sub smtp_to {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_TO} = shift : $self->{db}->{_ATTRS}{SMTP_TO};
}

sub smtp_cc {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_CC} = shift : $self->{db}->{_ATTRS}{SMTP_CC};
}

sub smtp_cc {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_BCC} = shift : $self->{db}->{_ATTRS}{SMTP_BCC};
}

sub smtp_subject {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_SUBJECT} = shift : $self->{db}->{_ATTRS}{SMTP_SUBJECT};
}

sub smtp_replayto {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_REPLAYTO} = shift : $self->{db}->{_ATTRS}{SMTP_REPLAYTO};
}

sub smtp_boundary {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_BOUNDARY} = shift : $self->{db}->{_ATTRS}{SMTP_BOUNDARY};
}

sub smtp_encoding {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_ENCODING} = shift : $self->{db}->{_ATTRS}{SMTP_ENCODING};
}

sub smtp_charset {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_CHARSET} = shift : $self->{db}->{_ATTRS}{SMTP_CHARSET};
}

sub smtp_type {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_TYPE} = shift : $self->{db}->{_ATTRS}{SMTP_TYPE};
}

sub smtp_ctype {
	my $self = shift;

	@_ ? $self->{db}->{_ATTRS}{SMTP_CTYPE} = shift : $self->{db}->{_ATTRS}{SMTP_CTYPE};
}

1;
