#!/usr/local/bin/perl
#
# cafCGI.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package cafMAIN;

BEGIN {
	chdir "..";
}

use cgi::cafCGI;
use cgi::conf;
use connectors::cafDBI;
use connectors::refDBI;
use tools::cafDbg;
use cgi::cafPage;

# sub initINC

my $refdbh;
my $pageh;

my $lang      = cafCGI->language();

push @INC, "cgi/$lang";
push @INC, "cgi/EN" unless ($lang eq 'EN');

my $sessionid = cafCGI->param("_sessionid");

my $userid    = cafCGI->param("_userid");

my $pageid    = cafCGI->param("_nextpage");

my $connectpage  = conf->conPage();

my $mainpage     = conf->mainPage();

my $usersess = {
	sessionid      => $sessionid,
	userid         => $userid,
	userpass       => cafCGI->param("_userpass"),
	ipaddress      => cafCGI->ipaddress(),
	lastactiontime => cafCGI->param("_lastactiontime"),
	connecttime    => cafCGI->param("_connecttime"),
};

sub openrefdb {
	my $conf  = shift;

	my $refdbh;
	eval {
		$refdbh = refDBI->OpenSession (conf->refdb(), $usersess);
	};
	my $e = $@;
	cafDbg->pusherror("10000; Cannot connect to database " . conf->refdbname() . "<BR>\n$@") unless ($refdbh);

	die "$e" if ($e);
	$sessionid = $refdbh->sessionid() if ($refdbh);
	return $refdbh;
}

sub pageattrs {

	my $refdbh = shift;

	my $newpageattrs;

	if ($refdbh) {
		$newpageattrs = {
			_system => {
				_userlabel      => $refdbh->userlabel (),
				_dbh            => $refdbh,
				_conf           => conf->new(),
				_cgi            => cafCGI->new(),
				_translate      => cafetrans->new(),
			},
			_hidden => {
				_currmenu          => cafCGI->param("_currmenu"),
				_currsubmenu       => cafCGI->param("_currsubmenu"),
				_sessionid         => $refdbh->sessionid (),
				_userid            => $refdbh->userid (),
				_lastactiontime    => $refdbh->lastactiontime (),
				_connecttime       => $refdbh->connecttime (),
				_nextaction        => undef,
				_nextpage          => undef,
				_prevpage          => cafCGI->param("_currpage"),
				_currpage          => $pageid,
				_curraction        => cafCGI->param("_nextaction"),
				_actiondetail      => cafCGI->param("_actiondetail"),
				_searchcall        => cafCGI->param("_searchcall"),
				_searchCriteria    => cafCGI->param("_searchCriteria"),
				_returnfields      => cafCGI->param("_returnfields"),
				_callerpage        => cafCGI->param("_callerpage"),
				_winsearchid       => cafCGI->param("_winsearchid") || 0,
			},
			_data   => {},
			"currentuser"              =>  $refdbh->userid (),
		}
	}
	else {
		$newpageattrs = {
			_system => {
				userlabel       => undef,
				_conf           => conf->new(),
				_cgi            => cafCGI->new(),
				_translate      => cafetrans->new(),
			},
			_hidden => {
				_sessionid         => cafCGI->param("_sessionid"),
				_userid            => cafCGI->param("_userid"),
				_nextaction        => undef,
				_nextpage          => undef,
				_prevpage          => cafCGI->param("_currpage"),
				_currpage          => $pageid,
				_curraction        => cafCGI->param("_nextaction"),
				_actiondetail      => cafCGI->param("_actiondetail"),
			},
			_data   => {},
		}
	}

	for (my $i = 0; $i < 10;  $i++) {
		my $paramvalue = cafCGI->param("__param__$i");
		$newpageattrs->{_hidden}{"__param__$i"} = $paramvalue;
	}
	$newpageattrs;
}

sub requirepage {
	my $refdbh = shift;

	$pageid = cafCGI->param("_nextpage");
	if (! $sessionid) { $pageid = $connectpage; }
	elsif (! $pageid) { $pageid = $mainpage; }

	eval "require translate";
#	eval "require $pageid";
	eval "require cgi::PM::$pageid";
	if ($@) {
		cafDbg->pusherror("00001; Can't load page $lang::$pageid<BR>\n$@");
		my $e = $@;
		$e =~ s/\n/<BR>\n/g;
		if (($pageid ne $connectpage) && ($pageid ne $mainpage)) {
			$pageid = $mainpage;
			eval "require $pageid";
			if ($@) {
				die "00002; Can't load page $lang::$pageid<BR>\n$@<BR>\n$e";
			}
		}
		else { die "00003; Can't load page $lang::$pageid<BR>\n$@<BR>\n$e"; }
	}
	return ($pageid->new(pageattrs($refdbh)));
}

sub initerrors {
	my $pageh = shift;
	my $errors = cafDbg->geterrorn();
 
	if ($errors >= 0) {
		$pageh->_attribute("_debug", "errortext", cafDbg->geterrors());
		$pageh->_attribute("_debug", "errors", $errors + 1);
	}
}

#main 

print cafCGI->printheader();
eval {
	eval { $refdbh = openrefdb (); };
	$pageh  = requirepage ($refdbh);

	eval { $pageh->startpage(); };
	initerrors($pageh);
	$pageh->checkredirect();
	$refdbh->disconnect () if ($refdbh);
};

if ($@) {
	my $e = $@ . "<BR> INC CONTAINS " . join ("<BR>", @INC);
	$e =~ s/\n/<P>\n/g;
	if ($refdbh) {
		if (my $q = $refdbh->lastquery()) { $e =  "<BR>\nlast query is: <I>" . $q->query() . "<BR>\n" . $e; }
		$e =  "<BR>\nlast error is : " . DBI->errstr . "<BR>\n" . $e;
		eval { $refdbh->disconnect(); };
	}
	print "<html><head></head><body><P><B>$e</B></body></html>";
	die "$e";
}

