#!/usr/local/bin/perl
#
# cafPage.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
use Data::Dumper;
use connectors::ObjHier;
use Cwd;
use File::Basename;

package CafExport;

@CafExport::ISA = ('cafPage');

# fName => "contextid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "exportid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "blindpasswd", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "blinduserlogin", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "blindhosts", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "usercomment", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->_datavar("_exportinfo", []);
	$self->$meth_name($cgi, $dbh, $conf);

}

sub CheckFields {
	my $self = shift;
	my $exportid = $self->_datavar("exportid");
	$exportid =~ s/[^[:alnum:]_]//g;
	if (!$exportid) { cafDbg->pusherror("exportid; You must supply an id to your export site"); }
	elsif ($exportid and ($exportid !~ /^[[:alpha:]_]/)) { $exportid = "_$exportid"; }
	$self->_datavar("exportid", $exportid);
}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	$self->_getcheckfields ($cgi, $editfields);

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	if ($actiondetail eq "search") {
		$self->_datavar("blindpasswd", "yes");
		$self->_datavar("blindhosts", "yes");
	}
	else { $self->CheckFields(); }

	my $objcounts = $cgi->param("_listexportedobjectscount");
	my @selectedObjects;
	my $exportedobjects = [];
	my %checkedObjects;
	for (my $i = 0; $i <= $objcounts; $i++) {
		my $objectid;
		next unless ($objectid = $cgi->param("object_id_$i"));
		$checkedObjects{$objectid} = $cgi->param("export_$i");
		push @selectedObjects, $objectid;
	}

	if ($#selectedObjects > -1) {
		my $query = $dbh->newquery({ object_id => \@selectedObjects });
		$query->sobjectlist();
		$exportedobjects = $dbh->hexecfetchall($query, 1) || [];
	}
	foreach my $obj (@$exportedobjects) { next unless ($obj); $obj->{export_it} = $checkedObjects{$obj->{object_id}}; }
	unshift @$exportedobjects, ({},{},{});
	$self->_hiddenvar ("_listexportedobjectscount", $#$exportedobjects);
	$self->{_exportedobjects} = $exportedobjects; 

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub BuildConfig {
	my $self = shift;
	my $conf = shift;
	my $config = shift;
	my $objectid = shift;

	$config->{context} = $self->_datavar("exportid");
	my $cwd = Cwd->getcwd();
	chdir $conf->wd();
	mkdir "exports" unless (-d "exports");
	chdir $cwd;
	
	my $date = cafUtils->datetime1();
	$config->{objectid} = $objectid;
	$config->{opackage} = $config->{context} . "_" . $objectid;
	$config->{ofile} = $config->{context} . "_" . $objectid . "_" . $date;
	$config->{ofile} =~ s/[\/]/_/g;
	$config->{ofile} =~ s/ ..:..:...*//g;
	$config->{ofile} .= ".pm";
	$config->{COMMENTS} = "Generated by Cafeterra : $date";
	$config->{USERCOMMENTS} = $self->_datavar("usercomment");
	$config->{CAFETERRA} = $conf->myversion();
	$config->{EXPORTDATE} = $date;
}

sub ExportObject {
	my $self = shift;
	my $dbh = shift;
	my $conf = shift;
	my $objectid = shift;

	my %config;
	my $migrobjs = {
		objects => {},
		thedump => {},
		attributes => {},
		mapping => [],
		objscr => {},
		otherobj => {},
		config => \%config,
		mapping => {}
	};
 
	my $objects = $migrobjs->{objects};
	my $thedump = $migrobjs->{thedump};
	my $attributes = $migrobjs->{attributes};
	my $otherobj = $migrobjs->{otherobj};
	my $objscr = $migrobjs->{objscr};
	my $mapping = $migrobjs->{mapping};


	my $objHier = ObjHier->new($dbh, "REPOSITORY", "NOCONTEXT", "NOCONTEXT");
	$objHier->gethierarchy($objectid);

	my $blindpasswd    = $self->_datavar("blindpasswd");
	my $blinduserlogin = $self->_datavar("blinduserlogin");
	my $blindhosts     = $self->_datavar("blindhosts");

	my @allobjs = $objHier->allobjects();
	{
		my %h =  map { $_ => $objHier->getobject($_)} @allobjs;
		foreach my $obj (values %h) {
			if ($obj->{parsetext}) { $obj->{parsetext} = $obj->{parsetext}{parsetext}; }
			if ($obj->{type} eq 'users') {
				if ($blindpasswd) { $obj->{password} = "change_on_install"; }
				if ($blinduserlogin) { $obj->{username} = "change_on_install"; }
			}
			if (($obj->{type} eq 'server') and $blindhosts) {
				$obj->{host_address} = "change_on_install";
			}
			if ($obj->{object_id} == $objectid) { $config{objecttype} = $obj->{type}; $config{objectlabel} = $obj->{objectlabel}; }
		}

		$migrobjs->{thedump} = \%h;
		$thedump = $migrobjs->{thedump};
	}
	{
		my %h = map { $_ => { last_modified => $thedump->{$_}{modified}} } @allobjs;
		$migrobjs->{objects} = \%h;
		$objects = $migrobjs->{objects};
	}

	$migrobjs->{objscr} = $objHier->{SCRIPTLIST};

	{
		my %h = ();
		foreach my $km (keys %{$objHier->{MAPPFIELDS} || {}}) {
			my @a = values %{$objHier->{MAPPFIELDS}{$km} || {}};
			$h{$km} = \@a;
		}
		$migrobjs->{mapping}    = \%h; #$objHier->{MAPPFIELDS}; #\%h;
	}


	$migrobjs->{otherobj} = $objHier->{OTHEROBJECTS} || {};

	{
		my %h = ();
		foreach my $km (keys %{$objHier->{ATTRIBUTES} || {}}) {
			my %a = map { $_->{attrdefid} => $_->{attrvalue} } @{$objHier->{ATTRIBUTES}{$km} || []};
			$h{$km} = \%a;
		}
		$migrobjs->{attributes} = \%h; 
	}

	my $query = $dbh->newquery();
	$query->query("select * from attrdef");
	my $rows = $dbh->hexecfetchall($query);

	$migrobjs->{attrdefs} = $rows;

	$self->BuildConfig($conf, \%config, $objectid);

	my $dump = Data::Dumper->new([$migrobjs], ["migrobjs"]);
	my $ptext = $dump->Dump;
	my $cwd = Cwd->getcwd();

	chdir $conf->wd();
	mkdir "exports" unless (-d "exports");
	chdir "exports";

	open FOUT, ">$config{ofile}";
	
	print FOUT "#
#COMMENT           = $config{COMMENTS}
#USER COMMENT      = $config{USERCOMMENTS}
#CAFETERRA VERSION = $config{CAFETERRA}
#OBJECT ID         = $config{objectid}
#OBJECT LABEL      = $config{objectlabel}
#OBJECT TYPE       = $config{objecttype}
#PACKAGE NAME      = $config{opackage}
#CONTEXT           = $config{context}
#EXPORT DATE       = $config{EXPORTDATE}
#FILENAME          = $config{ofile}
#
#

";
	print FOUT "package $config{opackage};\n";
	print FOUT $ptext, "\n";
	print FOUT "sub objectsrefs { return \$migrobjs; }\n\n1;\n";
	close FOUT;

	my $exportInfo = $self->_datavar("_exportinfo");
	my $expdir = Cwd->getcwd;
	my $textInfo = "<FONT COLOR=red><B>$config{objecttype} Object $objectid</B></FONT> was successfully exported to the file ";
	$textInfo .= "<B>$config{ofile}</B> in directory $expdir";
	push (@$exportInfo, $textInfo);
	chdir $cwd;

};


sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	my $objcounts = $cgi->param("_listexportedobjectscount");
	my @selectedObjects;
	my $exportedobjects = [];
	my %checkedObjects;
	for (my $i = 0; $i <= $objcounts; $i++) {
		my $objectid;
		next unless ($objectid = $cgi->param("object_id_$i"));
		$checkedObjects{$objectid} = $cgi->param("export_$i");
		if ($checkedObjects{$objectid}) {
			if ($self->ExportObject($dbh, $conf, $objectid)) {
				$checkedObjects{$objectid} = undef;
			}
		}
		push @selectedObjects, $objectid;
	}

	if ($#selectedObjects > -1) {
		my $query = $dbh->newquery({ object_id => \@selectedObjects });
		$query->sobjectlist();
		$exportedobjects = $dbh->hexecfetchall($query, 1) || [];
	}
	foreach my $obj (@$exportedobjects) { next unless ($obj); $obj->{export_it} = $checkedObjects{$obj->{object_id}}; }
	unshift @$exportedobjects, ({},{},{});
	$self->_hiddenvar ("_listexportedobjectscount", $#$exportedobjects);
	$self->{_exportedobjects} = $exportedobjects; 

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->icontext();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->ucontext();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vdeploy {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;


	my @selectedObjects;

	my $contextid = $cgi->param("_objectid");
	my $objcounts = $cgi->param("_listdeployedobjectscount");
	for (my $i = 0; $i <= $objcounts; $i++) {
		my $objectid;
		next unless $objectid = $cgi->param("object_id_$i");
		if ($cgi->param("update_$i") or $cgi->param("deploy_$i")) { push @selectedObjects, $objectid; }
	}
	return undef unless (@selectedObjects and ($#selectedObjects >= 0));

	my $query = $dbh->newquery({ contextid => $self->_datavar("contextid") });
	$query->scontextlist ();
	my $context = $dbh->hexecfetchrow($query, 1);

	foreach my $con (qw( connector_id ftpconnector_id mailconnector_id pop3connector_id archconnector_id)) {
		if ($context->{$con}) { push @selectedObjects, $context->{$con}; }
	}

	eval {
	require connectors::ObjHier;
	my $refrep = ObjHier->new($dbh, "REPOSITORY", $contextid, $context);
	$refrep->gethierarchy(\@selectedObjects);
#	my $ptext = $refrep->dumpall();
	
#	print "<TEXTAREA rows=10 cols=100>$ptext</TEXTAREA>";

	my $ret = $refrep->outputupdatable();
	
	if ($ret > 0) {
		$ret = $refrep->runsqlgeneratetables();
	}
	if ($ret > 0) {
		$dbh->commit();
		my $outdbh = $refrep->outdbh();
		$outdbh->commit();
	}
	else {
		$dbh->rollback();
		$refrep->outdbh()->rollback();
	}
	};
	if ($@) {
#		print "ERROR : $@<BR>";
		my $qryText;
		if (my $q = $dbh->lastquery()) {
			$qryText = $q->query();
#			my $e =  "<BR>\nlast query is: <I>" . $q->query() . "<BR>\n"; print "$e";
		}
		cafDbg->pushstackdump(1);
		cafDbg->pusherror("10000; ERROR WHILE DEPLOYING : $@ <BR>\nlast query is: <I>$qryText</I>\n");
	}

}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dcontext();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}

1;
