/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.annotations;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.codehaus.xfire.annotations.AnnotationException;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebMethodAnnotation;
import org.codehaus.xfire.annotations.WebParamAnnotation;
import org.codehaus.xfire.annotations.WebResultAnnotation;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.DefaultServiceConfiguration;

public class AnnotationServiceConfiguration
extends DefaultServiceConfiguration {
    private WebAnnotations webAnnotations;

    public void setWebAnnotations(WebAnnotations webAnnotations) {
        this.webAnnotations = webAnnotations;
    }

    public String getOperationName(ServiceInfo service, Method method) {
        WebMethodAnnotation wma;
        if (this.webAnnotations.hasWebMethodAnnotation(method) && (wma = this.webAnnotations.getWebMethodAnnotation(method)).getOperationName().length() > 0) {
            return wma.getOperationName();
        }
        return super.getOperationName(service, method);
    }

    public String getAction(OperationInfo op) {
        WebMethodAnnotation wma;
        if (this.webAnnotations.hasWebMethodAnnotation(op.getMethod()) && (wma = this.webAnnotations.getWebMethodAnnotation(op.getMethod())).getAction().length() > 0) {
            return wma.getAction();
        }
        return super.getAction(op);
    }

    public Boolean isOperation(Method method) {
        WebMethodAnnotation ann;
        if (this.webAnnotations.hasWebMethodAnnotation(method) && (ann = this.webAnnotations.getWebMethodAnnotation(method)).isExclude()) {
            return Boolean.FALSE;
        }
        if (method.getDeclaringClass().isInterface()) {
            return Boolean.TRUE;
        }
        return super.isOperation(method);
    }

    public Boolean isHeader(Method method, int paramNumber) {
        if (paramNumber != -1) {
            if (this.webAnnotations.hasWebParamAnnotation(method, paramNumber)) {
                WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, paramNumber);
                return new Boolean(webParamAnnotation.isHeader());
            }
        } else if (this.webAnnotations.hasWebResultAnnotation(method)) {
            WebResultAnnotation ann = this.webAnnotations.getWebResultAnnotation(method);
            return new Boolean(ann.isHeader());
        }
        return super.isHeader(method, paramNumber);
    }

    public Boolean isInParam(Method method, int j) {
        if (this.webAnnotations.hasWebParamAnnotation(method, j)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, j);
            return new Boolean(webParamAnnotation.getMode() == 0 || webParamAnnotation.getMode() == 1);
        }
        return super.isInParam(method, j);
    }

    public Boolean isOutParam(Method method, int j) {
        if (this.webAnnotations.hasWebParamAnnotation(method, j)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, j);
            return new Boolean(webParamAnnotation.getMode() == 2 || webParamAnnotation.getMode() == 1);
        }
        return super.isOutParam(method, j);
    }

    public QName getInParameterName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        QName name = paramNumber >= 0 ? this.getWebParamName(endpoint, op, method, paramNumber, doc) : this.getWebResultName(endpoint, op, method, paramNumber, doc);
        if (name == null) {
            name = super.getInParameterName(endpoint, op, method, paramNumber, doc);
        }
        return name;
    }

    private QName getWebParamName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        if (this.webAnnotations.hasWebParamAnnotation(method, paramNumber)) {
            String ns;
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, paramNumber);
            String name = webParamAnnotation.getName();
            if (name == null || name.length() == 0) {
                name = super.getInParameterName(endpoint, op, method, paramNumber, doc).getLocalPart();
            }
            if ((ns = webParamAnnotation.getTargetNamespace()) == null || ns.length() == 0) {
                ns = endpoint.getTargetNamespace();
            }
            return new QName(ns, name);
        }
        return null;
    }

    public QName getOutParameterName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        QName name = paramNumber >= 0 ? this.getWebParamName(endpoint, op, method, paramNumber, doc) : this.getWebResultName(endpoint, op, method, paramNumber, doc);
        if (name == null) {
            name = super.getOutParameterName(endpoint, op, method, paramNumber, doc);
        }
        return name;
    }

    private QName getWebResultName(Service endpoint, OperationInfo op, Method method, int param, boolean doc) {
        if (this.webAnnotations.hasWebResultAnnotation(method)) {
            String ns;
            WebResultAnnotation webResultAnnotation = this.webAnnotations.getWebResultAnnotation(method);
            String name = webResultAnnotation.getName();
            if (name == null || name.length() == 0) {
                name = super.getOutParameterName(endpoint, op, method, param, doc).getLocalPart();
            }
            if ((ns = webResultAnnotation.getTargetNamespace()) == null || ns.length() == 0) {
                ns = endpoint.getTargetNamespace();
            }
            return new QName(ns, name);
        }
        return super.getOutParameterName(endpoint, op, method, param, doc);
    }

    public Boolean isAsync(Method method) {
        boolean oneway = this.webAnnotations.hasOnewayAnnotation(method);
        if (oneway && !method.getReturnType().equals(Void.TYPE)) {
            throw new AnnotationException("Method " + method.getName() + " is marked as Oneway, but does not return void!");
        }
        if (oneway) {
            return Boolean.TRUE;
        }
        return super.isAsync(method);
    }

    public String getMEP(Method method) {
        if (this.webAnnotations.hasOnewayAnnotation(method)) {
            return "urn:xfire:mep:in";
        }
        return super.getMEP(method);
    }
}

