/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.BasicShape;
import org.apache.tools.ant.types.optional.image.ColorMapper;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Rectangle
extends BasicShape
implements DrawOperation {
    protected int width = 0;
    protected int height = 0;
    protected int arcwidth = 0;
    protected int archeight = 0;

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setArcwidth(int w) {
        this.arcwidth = w;
    }

    public void setArcheight(int h) {
        this.archeight = h;
    }

    @Override
    public PlanarImage executeDrawOperation() {
        this.log("\tCreating Rectangle w=" + this.width + " h=" + this.height + " arcw=" + this.arcwidth + " arch=" + this.archeight);
        BufferedImage bi = new BufferedImage(this.width, this.height, 7);
        Graphics2D graphics = bi.createGraphics();
        if (!"transparent".equalsIgnoreCase(this.stroke)) {
            BasicStroke bStroke = new BasicStroke(this.stroke_width);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            if (this.arcwidth == 0 && this.archeight == 0) {
                graphics.drawRect(0, 0, this.width, this.height);
            } else {
                graphics.drawRoundRect(0, 0, this.width, this.height, this.arcwidth, this.archeight);
            }
        }
        if (!"transparent".equalsIgnoreCase(this.fill)) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            if (this.arcwidth == 0 && this.archeight == 0) {
                graphics.fillRect(this.stroke_width, this.stroke_width, this.width - this.stroke_width * 2, this.height - this.stroke_width * 2);
            } else {
                graphics.fillRoundRect(this.stroke_width, this.stroke_width, this.width - this.stroke_width * 2, this.height - this.stroke_width * 2, this.arcwidth, this.archeight);
            }
        }
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                PlanarImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img.getAsBufferedImage(), null, 0, 0);
                continue;
            }
            if (!(instr instanceof TransformOperation)) continue;
            PlanarImage image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
            bi = image.getAsBufferedImage();
            graphics = bi.createGraphics();
        }
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }
}

