/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;

public class SSLHostConfigSF
extends StoreFactoryBase {
    private static final Log log = LogFactory.getLog(SSLHostConfigSF.class);

    @Override
    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
        if (elementDesc != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("factory.storeTag", new Object[]{elementDesc.getTag(), aElement}));
            }
            this.getStoreAppender().printIndent(aWriter, indent + 2);
            aWriter.print("<");
            aWriter.print(elementDesc.getTag());
            if (elementDesc.isAttributes()) {
                SSLHostConfig bean2 = (SSLHostConfig)this.getStoreAppender().defaultInstance(aElement);
                SSLHostConfig sslHostConfig = (SSLHostConfig)aElement;
                if (!bean2.getProtocols().equals(sslHostConfig.getProtocols())) {
                    StringBuilder protocolsValue = new StringBuilder();
                    for (String protocol : sslHostConfig.getProtocols()) {
                        protocolsValue.append('+').append(protocol);
                    }
                    this.getStoreAppender().printValue(aWriter, indent, "protocols", protocolsValue.toString());
                }
                this.getStoreAppender().printAttributes(aWriter, indent, aElement, elementDesc);
            }
            aWriter.println(">");
            this.storeChildren(aWriter, indent + 2, aElement, elementDesc);
            this.getStoreAppender().printIndent(aWriter, indent + 2);
            this.getStoreAppender().printCloseTag(aWriter, elementDesc);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{aElement.getClass()}));
        }
    }

    @Override
    public void storeChildren(PrintWriter aWriter, int indent, Object aSSLHostConfig, StoreDescription parentDesc) throws Exception {
        if (aSSLHostConfig instanceof SSLHostConfig) {
            SSLHostConfig sslHostConfig = (SSLHostConfig)aSSLHostConfig;
            Object[] hostConfigsCertificates = sslHostConfig.getCertificates().toArray(new SSLHostConfigCertificate[0]);
            if (hostConfigsCertificates.length > 1) {
                ArrayList<Object> certificates = new ArrayList<Object>();
                for (Object certificate : hostConfigsCertificates) {
                    if (SSLHostConfigCertificate.Type.UNDEFINED == certificate.getType()) continue;
                    certificates.add(certificate);
                }
                hostConfigsCertificates = certificates.toArray(new SSLHostConfigCertificate[0]);
            }
            this.storeElementArray(aWriter, indent, hostConfigsCertificates);
            OpenSSLConf openSslConf = sslHostConfig.getOpenSslConf();
            this.storeElement(aWriter, indent, openSslConf);
        }
    }
}

