/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.impl;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.formatting.IFormatterExtension;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenStringBuffer;
import org.eclipse.xtext.parsetree.reconstr.impl.WriterTokenStream;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.TokenStreamSequenceAdapter;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public class Serializer
implements ISerializer {
    @Inject(optional=true)
    protected IFormatter formatter;
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private Provider<TextRegionAccessBuilder> textRegionBuilderProvider;
    @Inject
    protected Provider<ISemanticSequencer> semanticSequencerProvider;
    @Inject
    protected Provider<ISyntacticSequencer> syntacticSequencerProvider;
    @Inject
    protected Provider<IHiddenTokenSequencer> hiddenTokenSequencerProvider;
    @Inject
    protected IGrammarAccess grammar;
    @Inject
    protected IContextFinder contextFinder;
    @Inject
    protected IConcreteSyntaxValidator validator;

    @Override
    public String serialize(EObject obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj must not be null.");
        return this.serialize(obj, SaveOptions.defaultOptions());
    }

    @Deprecated
    protected void serialize(EObject semanticObject, EObject context, ISequenceAcceptor tokens, ISerializationDiagnostic.Acceptor errors) {
        ISemanticSequencer semantic = (ISemanticSequencer)this.semanticSequencerProvider.get();
        ISyntacticSequencer syntactic = (ISyntacticSequencer)this.syntacticSequencerProvider.get();
        IHiddenTokenSequencer hidden = (IHiddenTokenSequencer)this.hiddenTokenSequencerProvider.get();
        semantic.init((ISemanticSequenceAcceptor)((Object)syntactic), errors);
        syntactic.init(context, semanticObject, (ISyntacticSequenceAcceptor)((Object)hidden), errors);
        hidden.init(context, semanticObject, tokens, errors);
        if (tokens instanceof TokenStreamSequenceAdapter) {
            ((TokenStreamSequenceAdapter)tokens).init(context);
        }
        semantic.createSequence(context, semanticObject);
    }

    protected void serialize(ISerializationContext context, EObject semanticObject, ISequenceAcceptor tokens, ISerializationDiagnostic.Acceptor errors) {
        ISemanticSequencer semantic = (ISemanticSequencer)this.semanticSequencerProvider.get();
        ISyntacticSequencer syntactic = (ISyntacticSequencer)this.syntacticSequencerProvider.get();
        IHiddenTokenSequencer hidden = (IHiddenTokenSequencer)this.hiddenTokenSequencerProvider.get();
        semantic.init((ISemanticSequenceAcceptor)((Object)syntactic), errors);
        syntactic.init(context, semanticObject, (ISyntacticSequenceAcceptor)((Object)hidden), errors);
        hidden.init(context, semanticObject, tokens, errors);
        if (tokens instanceof TokenStreamSequenceAdapter) {
            ((TokenStreamSequenceAdapter)tokens).init(context);
        }
        semantic.createSequence(context, semanticObject);
    }

    protected void serialize(EObject obj, ITokenStream tokenStream, SaveOptions options) throws IOException {
        ISerializationDiagnostic.Acceptor errors = ISerializationDiagnostic.EXCEPTION_THROWING_ACCEPTOR;
        ITokenStream formatterTokenStream = this.formatter instanceof IFormatterExtension ? ((IFormatterExtension)((Object)this.formatter)).createFormatterStream(obj, null, tokenStream, !options.isFormatting()) : this.formatter.createFormatterStream(null, tokenStream, !options.isFormatting());
        ISerializationContext context = this.getIContext(obj);
        TokenStreamSequenceAdapter acceptor = new TokenStreamSequenceAdapter(formatterTokenStream, this.grammar.getGrammar(), errors);
        this.serialize(context, obj, (ISequenceAcceptor)acceptor, errors);
        formatterTokenStream.flush();
    }

    public ITextRegionAccess serializeToRegions(EObject obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj must not be null.");
        ISerializationContext context = this.getIContext(obj);
        TextRegionAccessBuilder builder = (TextRegionAccessBuilder)this.textRegionBuilderProvider.get();
        ISerializationDiagnostic.Acceptor errors = ISerializationDiagnostic.EXCEPTION_THROWING_ACCEPTOR;
        this.serialize(context, obj, builder.forSequence(context, obj), errors);
        ITextRegionAccess regionAccess = builder.create();
        return regionAccess;
    }

    protected void serialize(EObject obj, Appendable appendable, SaveOptions options) throws IOException {
        ITextRegionAccess regionAccess = this.serializeToRegions(obj);
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setFormatUndefinedHiddenRegionsOnly(!options.isFormatting());
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List<ITextReplacement> replacements = formatter2.format(request);
        regionAccess.getRewriter().renderToAppendable(replacements, appendable);
    }

    @Deprecated
    protected EObject getContext(EObject semanticObject) {
        Iterator<EObject> contexts = this.contextFinder.findContextsByContentsAndContainer(semanticObject, null).iterator();
        if (!contexts.hasNext()) {
            throw new RuntimeException("No Context for " + EmfFormatter.objPath((EObject)semanticObject) + " could be found");
        }
        return contexts.next();
    }

    protected ISerializationContext getIContext(EObject semanticObject) {
        Iterator<ISerializationContext> contexts = this.contextFinder.findByContentsAndContainer(semanticObject, null).iterator();
        if (!contexts.hasNext()) {
            throw new RuntimeException("No Context for " + EmfFormatter.objPath((EObject)semanticObject) + " could be found");
        }
        return contexts.next();
    }

    @Override
    public String serialize(EObject obj, SaveOptions options) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null.");
        try {
            if (this.formatter2Provider != null) {
                StringBuilder builder = new StringBuilder();
                this.serialize(obj, builder, options);
                return builder.toString();
            }
            TokenStringBuffer tokenStringBuffer = new TokenStringBuffer();
            this.serialize(obj, tokenStringBuffer, options);
            return tokenStringBuffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(EObject obj, Writer writer, SaveOptions options) throws IOException {
        Preconditions.checkNotNull((Object)obj, (Object)"obj must not be null.");
        Preconditions.checkNotNull((Object)writer, (Object)"writer must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null.");
        if (this.formatter2Provider != null) {
            this.serialize(obj, (Appendable)writer, options);
            writer.flush();
        } else {
            this.serialize(obj, new WriterTokenStream(writer), options);
        }
    }

    @Override
    public ReplaceRegion serializeReplacement(EObject obj, SaveOptions options) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(obj);
        if (node == null) {
            throw new IllegalStateException("Cannot replace an obj that has no associated node");
        }
        String text = this.serialize(obj, options);
        int replaceRegionLength = this.calculateReplaceRegionLength(node, text);
        return new ReplaceRegion(node.getTotalOffset(), replaceRegionLength, text);
    }

    protected int calculateReplaceRegionLength(ICompositeNode node, String text) {
        String remainingText;
        int oldTextLength = node.getTotalLength();
        int newTextLength = text.length();
        if (newTextLength > oldTextLength && this.isWhitespace(remainingText = text.substring(oldTextLength)) && this.hiddenNodeFollows(node)) {
            return newTextLength;
        }
        return oldTextLength;
    }

    protected boolean hiddenNodeFollows(ICompositeNode node) {
        INode followingNode = this.getFollowingNode(node);
        if (followingNode instanceof ILeafNode) {
            return ((ILeafNode)followingNode).isHidden();
        }
        return false;
    }

    protected INode getFollowingNode(ICompositeNode node) {
        if (node != null && node.hasNextSibling()) {
            INode nextSibling = node.getNextSibling();
            Iterator<ILeafNode> nextSiblingLeafNodes = nextSibling.getLeafNodes().iterator();
            if (nextSiblingLeafNodes.hasNext()) {
                return nextSiblingLeafNodes.next();
            }
            return this.getFollowingNode(node.getParent());
        }
        return null;
    }

    protected boolean isWhitespace(String text) {
        return CharMatcher.whitespace().matchesAllOf((CharSequence)text);
    }
}

