/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.juli.OneLineFormatter;

public class JsonFormatter
extends OneLineFormatter {
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";

    public JsonFormatter() {
        String timeFormat = LogManager.getLogManager().getProperty(JsonFormatter.class.getName() + ".timeFormat");
        if (timeFormat == null) {
            timeFormat = DEFAULT_TIME_FORMAT;
        }
        this.setTimeFormat(timeFormat);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\"time\": \"");
        this.addTimestamp(sb, record.getMillis());
        sb.append("\", ");
        sb.append("\"level\": \"");
        sb.append(record.getLevel().getLocalizedName());
        sb.append("\", ");
        sb.append("\"thread\": \"");
        String threadName = Thread.currentThread().getName();
        if (threadName != null && threadName.startsWith("AsyncFileHandlerWriter-")) {
            sb.append(JsonFormatter.getThreadName(record.getThreadID()));
        } else {
            sb.append(threadName);
        }
        sb.append("\", ");
        sb.append("\"class\": \"");
        sb.append(record.getSourceClassName());
        sb.append("\", ");
        sb.append("\"method\": \"");
        sb.append(record.getSourceMethodName());
        sb.append("\", ");
        sb.append("\"message\": \"");
        sb.append(JSONFilter.escape(this.formatMessage(record)));
        Throwable t = record.getThrown();
        if (t != null) {
            sb.append("\", ");
            sb.append("\"throwable\": [");
            boolean first = true;
            do {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append('\"').append(JSONFilter.escape(t.toString())).append('\"');
                for (StackTraceElement element : t.getStackTrace()) {
                    sb.append(',').append('\"').append(' ').append(JSONFilter.escape(element.toString())).append('\"');
                }
            } while ((t = t.getCause()) != null);
            sb.append(']');
        } else {
            sb.append('\"');
        }
        sb.append('}');
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static class JSONFilter {
        public static String escape(String input) {
            return JSONFilter.escape(input, 0, input.length()).toString();
        }

        public static CharSequence escape(CharSequence input, int off, int length) {
            StringBuilder escaped = null;
            int lastUnescapedStart = off;
            for (int i = off; i < length; ++i) {
                char c = input.charAt(i);
                if (c >= ' ' && c != '\"' && c != '\\' && !Character.isHighSurrogate(c) && !Character.isLowSurrogate(c)) continue;
                if (escaped == null) {
                    escaped = new StringBuilder(length + 20);
                }
                if (lastUnescapedStart < i) {
                    escaped.append(input.subSequence(lastUnescapedStart, i));
                }
                lastUnescapedStart = i + 1;
                char popular = JSONFilter.getPopularChar(c);
                if (popular > '\u0000') {
                    escaped.append('\\').append(popular);
                    continue;
                }
                escaped.append("\\u");
                escaped.append(String.format("%04X", c));
            }
            if (escaped == null) {
                if (off == 0 && length == input.length()) {
                    return input;
                }
                return input.subSequence(off, length - off);
            }
            if (lastUnescapedStart < length) {
                escaped.append(input.subSequence(lastUnescapedStart, length));
            }
            return escaped.toString();
        }

        private JSONFilter() {
        }

        private static char getPopularChar(char c) {
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    return c;
                }
                case '\b': {
                    return 'b';
                }
                case '\f': {
                    return 'f';
                }
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\t': {
                    return 't';
                }
            }
            return '\u0000';
        }
    }
}

