/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VROverlayView_t
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAYHANDLE;
    public static final int TEXTURE;
    public static final int TEXTUREBOUNDS;

    public VROverlayView_t(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VROverlayView_t.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VROverlayHandle_t")
    public long overlayHandle() {
        return VROverlayView_t.noverlayHandle(this.address());
    }

    @NativeType(value="Texture_t")
    public Texture texture() {
        return VROverlayView_t.ntexture(this.address());
    }

    @NativeType(value="VRTextureBounds_t")
    public VRTextureBounds textureBounds() {
        return VROverlayView_t.ntextureBounds(this.address());
    }

    public static VROverlayView_t malloc() {
        return (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VROverlayView_t calloc() {
        return (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VROverlayView_t create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VROverlayView_t create(long address) {
        return (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)address);
    }

    @Nullable
    public static VROverlayView_t createSafe(long address) {
        return address == 0L ? null : (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VROverlayView_t.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VROverlayView_t.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VROverlayView_t.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayView_t.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VROverlayView_t.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VROverlayView_t.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VROverlayView_t.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VROverlayView_t malloc(MemoryStack stack) {
        return (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayView_t calloc(MemoryStack stack) {
        return (VROverlayView_t)VROverlayView_t.wrap(VROverlayView_t.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VROverlayView_t.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VROverlayView_t.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long noverlayHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)OVERLAYHANDLE);
    }

    public static Texture ntexture(long struct) {
        return Texture.create(struct + (long)TEXTURE);
    }

    public static VRTextureBounds ntextureBounds(long struct) {
        return VRTextureBounds.create(struct + (long)TEXTUREBOUNDS);
    }

    static {
        Struct.Layout layout = VROverlayView_t.__struct((Struct.Member[])new Struct.Member[]{VROverlayView_t.__member((int)8), VROverlayView_t.__member((int)Texture.SIZEOF, (int)Texture.ALIGNOF), VROverlayView_t.__member((int)VRTextureBounds.SIZEOF, (int)VRTextureBounds.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAYHANDLE = layout.offsetof(0);
        TEXTURE = layout.offsetof(1);
        TEXTUREBOUNDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VROverlayView_t, Buffer>
    implements NativeResource {
        private static final VROverlayView_t ELEMENT_FACTORY = VROverlayView_t.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VROverlayView_t getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VROverlayHandle_t")
        public long overlayHandle() {
            return VROverlayView_t.noverlayHandle(this.address());
        }

        @NativeType(value="Texture_t")
        public Texture texture() {
            return VROverlayView_t.ntexture(this.address());
        }

        @NativeType(value="VRTextureBounds_t")
        public VRTextureBounds textureBounds() {
            return VROverlayView_t.ntextureBounds(this.address());
        }
    }
}

