/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.itext.ITextBuiltInFontRecord;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public class ITextBuiltInFontRegistry
implements FontRegistry {
    private HashMap families = new HashMap();
    private String[] familyNames;

    public ITextBuiltInFontRegistry() {
        this.families.put("Symbol", this.createSymbolFamily());
        this.families.put("ZapfDingbats", this.createZapfDingbatsFamily());
        this.families.put("Times", this.createTimesFamily());
        this.families.put("Courier", this.createCourierFamily());
        this.families.put("Helvetica", this.createHelveticaFamily());
        this.familyNames = new String[]{"Symbol", "ZapfDingbats", "Times", "Courier", "Helvetica"};
    }

    private FontFamily createSymbolFamily() {
        DefaultFontFamily fontFamily = new DefaultFontFamily("Symbol");
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Symbol", false, false, false));
        return fontFamily;
    }

    private FontFamily createZapfDingbatsFamily() {
        DefaultFontFamily fontFamily = new DefaultFontFamily("ZapfDingbats");
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "ZapfDingbats", false, false, false));
        return fontFamily;
    }

    private FontFamily createTimesFamily() {
        DefaultFontFamily fontFamily = new DefaultFontFamily("Times");
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Times-Roman", false, false, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Times-Bold", true, false, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Times-Italic", false, true, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Times-BoldItalic", true, true, false));
        return fontFamily;
    }

    private FontFamily createCourierFamily() {
        DefaultFontFamily fontFamily = new DefaultFontFamily("Courier");
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Courier", false, false, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Courier-Bold", true, false, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Courier-Oblique", false, true, true));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Courier-BoldOblique", true, true, true));
        return fontFamily;
    }

    private FontFamily createHelveticaFamily() {
        DefaultFontFamily fontFamily = new DefaultFontFamily("Helvetica");
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Helvetica", false, false, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Helvetica-Bold", true, false, false));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Helvetica-Oblique", false, true, true));
        fontFamily.addFontRecord(new ITextBuiltInFontRecord(fontFamily, "Helvetica-BoldOblique", true, true, true));
        return fontFamily;
    }

    @Override
    public void initialize() {
    }

    @Override
    public FontFamily getFontFamily(String name) {
        return (FontFamily)this.families.get(name);
    }

    @Override
    public String[] getRegisteredFamilies() {
        return (String[])this.familyNames.clone();
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return (String[])this.familyNames.clone();
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FontCache getSecondLevelCache() {
        throw new UnsupportedOperationException();
    }
}

