/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TimephasedCostNormaliser;

public class MPPTimephasedBaselineCostNormaliser
implements TimephasedCostNormaliser {
    @Override
    public void normalise(ProjectCalendar projectCalendar, LinkedList<TimephasedCost> linkedList) {
        if (!linkedList.isEmpty()) {
            this.splitDays(projectCalendar, linkedList);
            this.mergeSameDay(linkedList);
            this.mergeSameCost(linkedList);
        }
    }

    private void splitDays(ProjectCalendar projectCalendar, LinkedList<TimephasedCost> linkedList) {
        LinkedList<TimephasedCost> linkedList2 = new LinkedList<TimephasedCost>();
        boolean bl = false;
        Calendar calendar = Calendar.getInstance();
        block0: for (TimephasedCost timephasedCost : linkedList) {
            if (bl) {
                calendar.setTime(timephasedCost.getStart());
                calendar.add(6, 1);
                timephasedCost.setStart(calendar.getTime());
                bl = false;
            }
            while (timephasedCost != null) {
                Date date = DateHelper.getDayStartDate(timephasedCost.getStart());
                Date date2 = DateHelper.getDayStartDate(timephasedCost.getFinish());
                if (timephasedCost.getFinish().getTime() == date2.getTime()) {
                    calendar.setTime(date2);
                    calendar.add(6, -1);
                    date2 = calendar.getTime();
                }
                if (date.getTime() == date2.getTime()) {
                    linkedList2.add(timephasedCost);
                    continue block0;
                }
                TimephasedCost[] timephasedCostArray = this.splitFirstDay(projectCalendar, timephasedCost);
                if (timephasedCostArray[0] != null) {
                    linkedList2.add(timephasedCostArray[0]);
                }
                if (timephasedCost.equals(timephasedCostArray[1])) continue block0;
                timephasedCost = timephasedCostArray[1];
            }
        }
        linkedList.clear();
        linkedList.addAll(linkedList2);
    }

    private TimephasedCost[] splitFirstDay(ProjectCalendar projectCalendar, TimephasedCost timephasedCost) {
        Date date;
        TimephasedCost[] timephasedCostArray = new TimephasedCost[2];
        Date date2 = timephasedCost.getStart();
        Duration duration = projectCalendar.getWork(date2, date = timephasedCost.getFinish(), TimeUnit.MINUTES);
        if (duration.getDuration() != 0.0) {
            double d;
            Date date3;
            Object object;
            Date date4;
            if (projectCalendar.isWorkingDate(date2)) {
                date4 = date2;
                object = projectCalendar.getFinishTime(date4);
                date3 = DateHelper.setTime(date4, (Date)object);
                Duration duration2 = projectCalendar.getWork(date4, date3, TimeUnit.MINUTES);
                d = ((Number)timephasedCost.getTotalAmount()).doubleValue() * duration2.getDuration() / duration.getDuration();
                TimephasedCost timephasedCost2 = new TimephasedCost();
                timephasedCost2.setStart(date4);
                timephasedCost2.setFinish(date3);
                timephasedCost2.setTotalAmount(d);
                timephasedCostArray[0] = timephasedCost2;
            } else {
                date3 = date2;
                d = 0.0;
            }
            date4 = projectCalendar.getNextWorkStart(date3);
            date3 = date;
            if (date4.getTime() > date3.getTime()) {
                object = null;
            } else {
                d = ((Number)timephasedCost.getTotalAmount()).doubleValue() - d;
                object = new TimephasedCost();
                ((TimephasedItem)object).setStart(date4);
                ((TimephasedItem)object).setFinish(date3);
                ((TimephasedItem)object).setTotalAmount(d);
                ((TimephasedItem)object).setAmountPerDay((Number)timephasedCost.getAmountPerDay());
            }
            timephasedCostArray[1] = object;
        }
        return timephasedCostArray;
    }

    private void mergeSameDay(LinkedList<TimephasedCost> linkedList) {
        LinkedList<TimephasedCost> linkedList2 = new LinkedList<TimephasedCost>();
        TimephasedItem timephasedItem = null;
        for (TimephasedCost timephasedCost : linkedList) {
            if (timephasedItem == null) {
                timephasedCost.setAmountPerDay((Number)timephasedCost.getTotalAmount());
                linkedList2.add(timephasedCost);
            } else {
                Date date = timephasedItem.getStart();
                Date date2 = DateHelper.getDayStartDate(date);
                Date date3 = timephasedCost.getStart();
                Date date4 = DateHelper.getDayStartDate(date3);
                if (date2.getTime() == date4.getTime()) {
                    linkedList2.removeLast();
                    double d = ((Number)timephasedItem.getTotalAmount()).doubleValue();
                    TimephasedCost timephasedCost2 = new TimephasedCost();
                    timephasedCost2.setStart(timephasedItem.getStart());
                    timephasedCost2.setFinish(timephasedCost.getFinish());
                    timephasedCost2.setTotalAmount(d += ((Number)timephasedCost.getTotalAmount()).doubleValue());
                    timephasedCost = timephasedCost2;
                }
                timephasedCost.setAmountPerDay((Number)timephasedCost.getTotalAmount());
                linkedList2.add(timephasedCost);
            }
            timephasedItem = timephasedCost;
        }
        linkedList.clear();
        linkedList.addAll(linkedList2);
    }

    protected void mergeSameCost(LinkedList<TimephasedCost> linkedList) {
        LinkedList<TimephasedCost> linkedList2 = new LinkedList<TimephasedCost>();
        TimephasedItem timephasedItem = null;
        for (TimephasedCost timephasedCost : linkedList) {
            if (timephasedItem == null) {
                timephasedCost.setAmountPerDay((Number)timephasedCost.getTotalAmount());
                linkedList2.add(timephasedCost);
            } else {
                Number number = (Number)timephasedItem.getAmountPerDay();
                Number number2 = (Number)timephasedCost.getTotalAmount();
                if (NumberHelper.equals(number.doubleValue(), number2.doubleValue(), 0.01)) {
                    Date date = timephasedItem.getStart();
                    Date date2 = timephasedCost.getFinish();
                    double d = ((Number)timephasedItem.getTotalAmount()).doubleValue();
                    TimephasedCost timephasedCost2 = new TimephasedCost();
                    timephasedCost2.setStart(date);
                    timephasedCost2.setFinish(date2);
                    timephasedCost2.setAmountPerDay(number2);
                    timephasedCost2.setTotalAmount(d += number2.doubleValue());
                    linkedList2.removeLast();
                    timephasedCost = timephasedCost2;
                } else {
                    timephasedCost.setAmountPerDay((Number)timephasedCost.getTotalAmount());
                }
                linkedList2.add(timephasedCost);
            }
            timephasedItem = timephasedCost;
        }
        linkedList.clear();
        linkedList.addAll(linkedList2);
    }
}

