/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.GridLayout;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sf.mpxj.explorer.MpxjTreeNode;
import net.sf.mpxj.explorer.ObjectPropertiesPanel;
import net.sf.mpxj.explorer.ProjectTreeController;
import net.sf.mpxj.explorer.ProjectTreeModel;
import net.sf.mpxj.explorer.ProjectTreeView;

public class ProjectFilePanel
extends JPanel {
    private final ProjectTreeModel m_treeModel = new ProjectTreeModel();
    private final ProjectTreeController m_treeController = new ProjectTreeController(this.m_treeModel);
    private final ProjectTreeView m_treeView;
    final Map<MpxjTreeNode, ObjectPropertiesPanel> m_openTabs;

    public ProjectFilePanel(File file) {
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.m_treeView = new ProjectTreeView(this.m_treeModel);
        this.m_treeView.setShowsRootHandles(true);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(0.3);
        this.add(jSplitPane);
        JScrollPane jScrollPane = new JScrollPane(this.m_treeView);
        jSplitPane.setLeftComponent(jScrollPane);
        final JTabbedPane jTabbedPane = new JTabbedPane(1);
        jSplitPane.setRightComponent(jTabbedPane);
        this.m_openTabs = new HashMap<MpxjTreeNode, ObjectPropertiesPanel>();
        this.m_treeView.addTreeSelectionListener(new TreeSelectionListener(){
            final /* synthetic */ ProjectFilePanel this$0;
            {
                this.this$0 = projectFilePanel;
            }

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getPath();
                MpxjTreeNode mpxjTreeNode = (MpxjTreeNode)treePath.getLastPathComponent();
                if (!(mpxjTreeNode.getUserObject() instanceof String)) {
                    ObjectPropertiesPanel objectPropertiesPanel = this.this$0.m_openTabs.get(mpxjTreeNode);
                    if (objectPropertiesPanel == null) {
                        objectPropertiesPanel = new ObjectPropertiesPanel(mpxjTreeNode.getUserObject(), mpxjTreeNode.getExcludedMethods());
                        jTabbedPane.add(mpxjTreeNode.toString(), objectPropertiesPanel);
                        this.this$0.m_openTabs.put(mpxjTreeNode, objectPropertiesPanel);
                    }
                    jTabbedPane.setSelectedComponent(objectPropertiesPanel);
                }
            }
        });
        this.m_treeController.loadFile(file);
    }

    public void saveFile(File file, String string) {
        if (file != null) {
            this.m_treeController.saveFile(file, string);
        }
    }
}

