/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.time;

import com.projectlibre.core.time.TimeInterval;
import java.util.Date;

public class DefaultTimeInterval
implements TimeInterval {
    protected static long EMPTY_START = -1L;
    protected static long EMPTY_END = -1L;
    protected long start = EMPTY_START;
    protected long end = EMPTY_END;

    public DefaultTimeInterval() {
    }

    public DefaultTimeInterval(long l, long l2) {
        this.start = l;
        this.end = l2;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public void setStart(long l) {
        this.start = l;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(long l) {
        this.end = l;
    }

    @Override
    public void union(TimeInterval timeInterval) {
        if (this.start > timeInterval.getStart()) {
            this.start = timeInterval.getStart();
        }
        if (this.end < timeInterval.getEnd()) {
            this.end = timeInterval.getEnd();
        }
    }

    @Override
    public void inter(TimeInterval timeInterval) {
        if (this.start < timeInterval.getStart()) {
            this.start = timeInterval.getStart();
        }
        if (timeInterval.getEnd() < this.end) {
            this.end = timeInterval.getEnd();
        }
        if (this.start > this.end) {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.start = EMPTY_START;
        this.end = EMPTY_END;
    }

    @Override
    public boolean isEmpty() {
        return this.start == EMPTY_START || this.end == EMPTY_END;
    }

    @Override
    public int compareTo(TimeInterval timeInterval) {
        if (this.isEmpty()) {
            return -1;
        }
        if (this.start < timeInterval.getStart() || this.start == timeInterval.getStart() && this.end < timeInterval.getEnd()) {
            return -1;
        }
        if (this.start == timeInterval.getStart() && this.end == timeInterval.getEnd()) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DefaultTimeInterval)) {
            return false;
        }
        DefaultTimeInterval defaultTimeInterval = (DefaultTimeInterval)object;
        return this.start == defaultTimeInterval.getStart() && this.end == defaultTimeInterval.getEnd();
    }

    public String toString() {
        return "[" + String.valueOf(new Date(this.start)) + "," + String.valueOf(new Date(this.end)) + "]";
    }
}

