/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.SignerOutputStream;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)XMLSignature.class.getName());
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA1 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    private SignedInfo _signedInfo = null;
    private KeyInfo _keyInfo = null;
    private boolean _followManifestsDuringValidation = false;
    private Element signatureValueElement;
    private static final int MODE_SIGN = 0;
    private static final int MODE_VERIFY = 1;
    private int _state = 0;

    public XMLSignature(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, string2, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string, String string2, int n) throws XMLSecurityException {
        this(document, string, string2, n, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string, String string2, String string3) throws XMLSecurityException {
        this(document, string, string2, 0, string3);
    }

    public XMLSignature(Document document, String string, String string2, int n, String string3) throws XMLSecurityException {
        super(document);
        String string4 = XMLSignature.getDefaultPrefixBindings("http://www.w3.org/2000/09/xmldsig#");
        if (string4 == null) {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string4, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._signedInfo = new SignedInfo(this._doc, string2, n, string3);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Document document, String string, Element element, Element element2) throws XMLSecurityException {
        super(document);
        String string2 = XMLSignature.getDefaultPrefixBindings("http://www.w3.org/2000/09/xmldsig#");
        if (string2 == null) {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string2, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._signedInfo = new SignedInfo(this._doc, element, element2);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Element element, String string) throws XMLSignatureException, XMLSecurityException {
        super(element, string);
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        if (element2 == null) {
            Object[] objectArray = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this._signedInfo = new SignedInfo(element2, string);
        element2 = XMLUtils.getNextElement(element.getFirstChild());
        this.signatureValueElement = XMLUtils.getNextElement(element2.getNextSibling());
        if (this.signatureValueElement == null) {
            Object[] objectArray = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        Element element3 = XMLUtils.getNextElement(this.signatureValueElement.getNextSibling());
        if (element3 != null && element3.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element3.getLocalName().equals("KeyInfo")) {
            this._keyInfo = new KeyInfo(element3, string);
        }
        this._state = 1;
    }

    public void setId(String string) {
        if (string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public SignedInfo getSignedInfo() {
        return this._signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        try {
            return Base64.decode(this.signatureValueElement);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    private void setSignatureValueElement(byte[] byArray) {
        while (this.signatureValueElement.hasChildNodes()) {
            this.signatureValueElement.removeChild(this.signatureValueElement.getFirstChild());
        }
        String string = Base64.encode(byArray);
        if (string.length() > 76 && !XMLUtils.ignoreLineBreaks()) {
            string = "\n" + string + "\n";
        }
        Text text = this._doc.createTextNode(string);
        this.signatureValueElement.appendChild(text);
    }

    public KeyInfo getKeyInfo() {
        if (this._state == 0 && this._keyInfo == null) {
            this._keyInfo = new KeyInfo(this._doc);
            Element element = this._keyInfo.getElement();
            Element element2 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Object", 0);
            if (element2 != null) {
                this._constructionElement.insertBefore(element, element2);
                XMLUtils.addReturnBeforeChild(this._constructionElement, element2);
            } else {
                this._constructionElement.appendChild(element);
                XMLUtils.addReturnToElement(this._constructionElement);
            }
        }
        return this._keyInfo;
    }

    public void appendObject(ObjectContainer objectContainer) throws XMLSignatureException {
        this._constructionElement.appendChild(objectContainer.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public ObjectContainer getObjectItem(int n) {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Object", n);
        try {
            return new ObjectContainer(element, this._baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key key) throws XMLSignatureException {
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            try {
                signatureAlgorithm.initSign(key);
                signedInfo.generateDigestValues();
                UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(new SignerOutputStream(signatureAlgorithm));
                signedInfo.signInOctectStream(unsyncBufferedOutputStream);
                ((OutputStream)unsyncBufferedOutputStream).close();
            }
            catch (IOException iOException) {
                signatureAlgorithm.clearSignatureCache();
            }
            catch (XMLSecurityException xMLSecurityException) {
                signatureAlgorithm.clearSignatureCache();
                throw xMLSecurityException;
            }
            this.setSignatureValueElement(signatureAlgorithm.sign());
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addResourceResolver(ResourceResolver resourceResolver) {
        this.getSignedInfo().addResourceResolver(resourceResolver);
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.getSignedInfo().addResourceResolver(resourceResolverSpi);
    }

    public boolean checkSignatureValue(X509Certificate x509Certificate) throws XMLSignatureException {
        if (x509Certificate != null) {
            return this.checkSignatureValue(x509Certificate.getPublicKey());
        }
        Object[] objectArray = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", objectArray);
    }

    public boolean checkSignatureValue(Key key) throws XMLSignatureException {
        if (key == null) {
            Object[] objectArray = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", objectArray);
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SignatureMethodURI = " + signatureAlgorithm.getAlgorithmURI()));
                log.debug((Object)("jceSigAlgorithm    = " + signatureAlgorithm.getJCEAlgorithmString()));
                log.debug((Object)("jceSigProvider     = " + signatureAlgorithm.getJCEProviderName()));
                log.debug((Object)("PublicKey = " + key));
            }
            byte[] byArray = null;
            try {
                signatureAlgorithm.initVerify(key);
                SignerOutputStream signerOutputStream = new SignerOutputStream(signatureAlgorithm);
                UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(signerOutputStream);
                signedInfo.signInOctectStream(unsyncBufferedOutputStream);
                ((OutputStream)unsyncBufferedOutputStream).close();
                byArray = this.getSignatureValue();
            }
            catch (IOException iOException) {
                signatureAlgorithm.clearVerificationCache();
            }
            catch (XMLSecurityException xMLSecurityException) {
                signatureAlgorithm.clearVerificationCache();
                throw xMLSecurityException;
            }
            if (!signatureAlgorithm.verify(byArray)) {
                log.warn((Object)"Signature verification failed.");
                return false;
            }
            return signedInfo.verify(this._followManifestsDuringValidation);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addDocument(String string, Transforms transforms, String string2, String string3, String string4) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, transforms, string2, string3, string4);
    }

    public void addDocument(String string, Transforms transforms, String string2) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, transforms, string2, null, null);
    }

    public void addDocument(String string, Transforms transforms) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String string) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate x509Certificate) throws XMLSecurityException {
        X509Data x509Data = new X509Data(this._doc);
        x509Data.addCertificate(x509Certificate);
        this.getKeyInfo().add(x509Data);
    }

    public void addKeyInfo(PublicKey publicKey) {
        this.getKeyInfo().add(publicKey);
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return this.getSignedInfo().createSecretKey(byArray);
    }

    public void setFollowNestedManifests(boolean bl) {
        this._followManifestsDuringValidation = bl;
    }

    public String getBaseLocalName() {
        return "Signature";
    }
}

