/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks;

import com.beust.jcommander.JCommander;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.BleichenbacherCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.Cve20162107CommandConfig;
import de.rub.nds.tlsattacker.attacks.config.EarlyCCSCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.EarlyFinishedCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.GeneralDrownCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.HeartbleedCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.InvalidCurveAttackConfig;
import de.rub.nds.tlsattacker.attacks.config.Lucky13CommandConfig;
import de.rub.nds.tlsattacker.attacks.config.PaddingOracleCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.PoodleCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.PskBruteForcerAttackClientCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.PskBruteForcerAttackServerCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.SimpleMitmProxyCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.SpecialDrownCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.TLSPoodleCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.GeneralAttackDelegate;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.attacks.impl.BleichenbacherAttacker;
import de.rub.nds.tlsattacker.attacks.impl.Cve20162107Attacker;
import de.rub.nds.tlsattacker.attacks.impl.EarlyCCSAttacker;
import de.rub.nds.tlsattacker.attacks.impl.EarlyFinishedAttacker;
import de.rub.nds.tlsattacker.attacks.impl.HeartbleedAttacker;
import de.rub.nds.tlsattacker.attacks.impl.InvalidCurveAttacker;
import de.rub.nds.tlsattacker.attacks.impl.Lucky13Attacker;
import de.rub.nds.tlsattacker.attacks.impl.PaddingOracleAttacker;
import de.rub.nds.tlsattacker.attacks.impl.PoodleAttacker;
import de.rub.nds.tlsattacker.attacks.impl.PskBruteForcerAttackClient;
import de.rub.nds.tlsattacker.attacks.impl.PskBruteForcerAttackServer;
import de.rub.nds.tlsattacker.attacks.impl.SimpleMitmProxy;
import de.rub.nds.tlsattacker.attacks.impl.TLSPoodleAttacker;
import de.rub.nds.tlsattacker.attacks.impl.drown.GeneralDrownAttacker;
import de.rub.nds.tlsattacker.attacks.impl.drown.SpecialDrownAttacker;
import de.rub.nds.tlsattacker.core.config.TLSDelegateConfig;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void main(String[] args) {
        GeneralAttackDelegate generalDelegate = new GeneralAttackDelegate();
        JCommander jc = new JCommander((Object)generalDelegate);
        BleichenbacherCommandConfig bleichenbacherTest = new BleichenbacherCommandConfig(generalDelegate);
        jc.addCommand("bleichenbacher", (Object)bleichenbacherTest);
        PskBruteForcerAttackServerCommandConfig pskBruteForcerAttackServerTest = new PskBruteForcerAttackServerCommandConfig(generalDelegate);
        jc.addCommand("pskbruteforcerserver", (Object)pskBruteForcerAttackServerTest);
        PskBruteForcerAttackClientCommandConfig pskBruteForcerAttackClientTest = new PskBruteForcerAttackClientCommandConfig(generalDelegate);
        jc.addCommand("pskbruteforcerclient", (Object)pskBruteForcerAttackClientTest);
        InvalidCurveAttackConfig ellipticTest = new InvalidCurveAttackConfig(generalDelegate);
        jc.addCommand("invalid_curve", (Object)ellipticTest);
        HeartbleedCommandConfig heartbleed = new HeartbleedCommandConfig(generalDelegate);
        jc.addCommand("heartbleed", (Object)heartbleed);
        Lucky13CommandConfig lucky13 = new Lucky13CommandConfig(generalDelegate);
        jc.addCommand("lucky13", (Object)lucky13);
        PaddingOracleCommandConfig paddingOracle = new PaddingOracleCommandConfig(generalDelegate);
        jc.addCommand("padding_oracle", (Object)paddingOracle);
        TLSPoodleCommandConfig tlsPoodle = new TLSPoodleCommandConfig(generalDelegate);
        jc.addCommand("tls_poodle", (Object)tlsPoodle);
        Cve20162107CommandConfig cve20162107 = new Cve20162107CommandConfig(generalDelegate);
        jc.addCommand("cve20162107", (Object)cve20162107);
        EarlyCCSCommandConfig earlyCCS = new EarlyCCSCommandConfig(generalDelegate);
        jc.addCommand("early_ccs", (Object)earlyCCS);
        EarlyFinishedCommandConfig earlyFin = new EarlyFinishedCommandConfig(generalDelegate);
        jc.addCommand("early_finished", (Object)earlyFin);
        PoodleCommandConfig poodle = new PoodleCommandConfig(generalDelegate);
        jc.addCommand("poodle", (Object)poodle);
        SimpleMitmProxyCommandConfig simpleMitmProxy = new SimpleMitmProxyCommandConfig(generalDelegate);
        jc.addCommand("simple_mitm_proxy", (Object)simpleMitmProxy);
        GeneralDrownCommandConfig generalDrownConfig = new GeneralDrownCommandConfig(generalDelegate);
        jc.addCommand("generalDrown", (Object)generalDrownConfig);
        SpecialDrownCommandConfig specialDrownConfig = new SpecialDrownCommandConfig(generalDelegate);
        jc.addCommand("specialDrown", (Object)specialDrownConfig);
        jc.parse(args);
        if (generalDelegate.isHelp() || jc.getParsedCommand() == null) {
            if (jc.getParsedCommand() == null) {
                jc.usage();
            } else {
                jc.usage(jc.getParsedCommand());
            }
            return;
        }
        Attacker attacker = null;
        switch (jc.getParsedCommand()) {
            case "bleichenbacher": {
                attacker = new BleichenbacherAttacker(bleichenbacherTest, bleichenbacherTest.createConfig());
                break;
            }
            case "invalid_curve": {
                attacker = new InvalidCurveAttacker(ellipticTest, ellipticTest.createConfig());
                break;
            }
            case "heartbleed": {
                attacker = new HeartbleedAttacker(heartbleed, heartbleed.createConfig());
                break;
            }
            case "lucky13": {
                attacker = new Lucky13Attacker(lucky13, lucky13.createConfig());
                break;
            }
            case "tls_poodle": {
                attacker = new TLSPoodleAttacker(tlsPoodle, tlsPoodle.createConfig());
                break;
            }
            case "padding_oracle": {
                attacker = new PaddingOracleAttacker(paddingOracle, paddingOracle.createConfig());
                break;
            }
            case "cve20162107": {
                attacker = new Cve20162107Attacker(cve20162107, cve20162107.createConfig());
                break;
            }
            case "early_ccs": {
                attacker = new EarlyCCSAttacker(earlyCCS, earlyCCS.createConfig());
                break;
            }
            case "early_finished": {
                attacker = new EarlyFinishedAttacker(earlyFin, earlyFin.createConfig());
                break;
            }
            case "poodle": {
                attacker = new PoodleAttacker(poodle, poodle.createConfig());
                break;
            }
            case "simple_mitm_proxy": {
                attacker = new SimpleMitmProxy(simpleMitmProxy, simpleMitmProxy.createConfig());
                break;
            }
            case "pskbruteforcerclient": {
                attacker = new PskBruteForcerAttackClient(pskBruteForcerAttackClientTest, pskBruteForcerAttackClientTest.createConfig());
                break;
            }
            case "pskbruteforcerserver": {
                attacker = new PskBruteForcerAttackServer(pskBruteForcerAttackServerTest, pskBruteForcerAttackServerTest.createConfig());
                break;
            }
            case "generalDrown": {
                attacker = new GeneralDrownAttacker(generalDrownConfig, generalDrownConfig.createConfig());
                break;
            }
            case "specialDrown": {
                attacker = new SpecialDrownAttacker(specialDrownConfig, specialDrownConfig.createConfig());
                break;
            }
            default: {
                throw new ConfigurationException("Command not found");
            }
        }
        if (attacker == null) {
            throw new ConfigurationException("Attacker not found");
        }
        if (Main.isPrintHelpForCommand(jc, attacker.getConfig())) {
            jc.usage(jc.getParsedCommand());
        } else if (((AttackConfig)attacker.getConfig()).isExecuteAttack()) {
            attacker.attack();
        } else {
            try {
                Boolean result = attacker.checkVulnerability();
                if (Objects.equals(result, Boolean.TRUE)) {
                    ConsoleLogger.CONSOLE.error("Vulnerable:" + result.toString());
                } else if (Objects.equals(result, Boolean.FALSE)) {
                    ConsoleLogger.CONSOLE.info("Vulnerable:" + result.toString());
                } else {
                    ConsoleLogger.CONSOLE.warn("Vulnerable: Uncertain");
                }
            }
            catch (UnsupportedOperationException E) {
                LOGGER.info("The selected attacker is currently not implemented");
            }
        }
    }

    public static boolean isPrintHelpForCommand(JCommander jc, TLSDelegateConfig config) {
        return config.getGeneralDelegate().isHelp();
    }
}

