/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.util.ByRef;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5303)
public class HashMapBucket<K, V> {
    final Map<MultimapObjectWrapper<K>, V> values;

    private HashMapBucket(Map<MultimapObjectWrapper<K>, V> values) {
        this.values = values;
    }

    @ProtoFactory
    HashMapBucket(Collection<BucketEntry<K, V>> wrappedValues) {
        this.values = wrappedValues.stream().collect(Collectors.toMap(e -> new MultimapObjectWrapper(e.getKey()), BucketEntry::getValue));
    }

    public static <K, V> HashMapBucket<K, V> create(Map<K, V> values) {
        return new HashMapBucket<K, V>(HashMapBucket.toStore(values));
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    Collection<BucketEntry<K, V>> getWrappedValues() {
        return this.values.entrySet().stream().map(BucketEntry::new).collect(Collectors.toList());
    }

    public HashMapBucketResponse<Integer, K, V> putAll(Map<K, V> map) {
        HashMap<MultimapObjectWrapper<MultimapObjectWrapper<K>>, V> copied = new HashMap<MultimapObjectWrapper<MultimapObjectWrapper<K>>, V>(this.values);
        int res = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V prev = copied.put(new MultimapObjectWrapper<K>(entry.getKey()), entry.getValue());
            if (prev != null) continue;
            ++res;
        }
        return new HashMapBucketResponse<Integer, K, V>(res, new HashMapBucket<K, V>(copied));
    }

    public HashMapBucketResponse<Integer, K, V> putIfAbsent(Map<K, V> map) {
        ByRef.Integer created = new ByRef.Integer(0);
        HashMap<MultimapObjectWrapper<MultimapObjectWrapper>, Object> copied = new HashMap<MultimapObjectWrapper<MultimapObjectWrapper>, Object>(this.values);
        for (Map.Entry entry : map.entrySet()) {
            copied.computeIfAbsent(new MultimapObjectWrapper<K>(entry.getKey()), ignore -> {
                created.inc();
                return entry.getValue();
            });
        }
        return new HashMapBucketResponse<Integer, K, V>(created.get(), new HashMapBucket<K, V>(copied));
    }

    public Map<K, V> getAll(Set<K> keys) {
        HashMap<K, V> response = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            response.put(key, this.values.get(new MultimapObjectWrapper<K>(key)));
        }
        return response;
    }

    public Map<K, V> converted() {
        return this.fromStore();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public HashMapBucketResponse<Integer, K, V> removeAll(Collection<K> keys) {
        int res = 0;
        HashMap<MultimapObjectWrapper<K>, V> copied = new HashMap<MultimapObjectWrapper<K>, V>(this.values.size());
        for (Map.Entry<MultimapObjectWrapper<K>, V> entry : this.values.entrySet()) {
            if (this.containsKey(keys, entry.getKey())) {
                ++res;
                continue;
            }
            copied.put(entry.getKey(), entry.getValue());
        }
        return new HashMapBucketResponse(res, new HashMapBucket(copied));
    }

    public V get(K k) {
        return this.values.get(new MultimapObjectWrapper<K>(k));
    }

    public int size() {
        return this.values.size();
    }

    public Collection<V> values() {
        return new ArrayList<V>(this.values.values());
    }

    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>(this.values.size());
        for (MultimapObjectWrapper<K> key : this.values.keySet()) {
            keys.add(key.get());
        }
        return keys;
    }

    public boolean containsKey(K key) {
        return this.values.containsKey(new MultimapObjectWrapper<K>(key));
    }

    public HashMapBucket<K, V> replace(K key, V expected, V replacement) {
        MultimapObjectWrapper<K> storeKey = new MultimapObjectWrapper<K>(key);
        V current = this.values.get(storeKey);
        if (!this.equalValues(current, expected)) {
            return null;
        }
        if (this.equalValues(current, replacement)) {
            return this;
        }
        if (this.values.isEmpty()) {
            HashMap<MultimapObjectWrapper<K>, V> copied = new HashMap<MultimapObjectWrapper<K>, V>();
            copied.put(storeKey, replacement);
            return new HashMapBucket(copied);
        }
        HashMap<MultimapObjectWrapper<MultimapObjectWrapper<K>>, V> copied = new HashMap<MultimapObjectWrapper<MultimapObjectWrapper<K>>, V>(this.values);
        if (replacement == null) {
            copied.remove(storeKey, expected);
        } else {
            copied.put(storeKey, replacement);
        }
        return new HashMapBucket<K, V>(copied);
    }

    private boolean equalValues(V one, Object other) {
        boolean eq = one instanceof byte[] && other instanceof byte[] ? Arrays.equals((byte[])one, (byte[])other) : Objects.equals(one, other);
        return eq;
    }

    private static <K, V> Map<MultimapObjectWrapper<K>, V> toStore(Map<K, V> raw) {
        HashMap<MultimapObjectWrapper<K>, V> converted = new HashMap<MultimapObjectWrapper<K>, V>();
        for (Map.Entry<K, V> entry : raw.entrySet()) {
            converted.put(new MultimapObjectWrapper<K>(entry.getKey()), entry.getValue());
        }
        return converted;
    }

    private Map<K, V> fromStore() {
        HashMap<K, V> converted = new HashMap<K, V>();
        for (Map.Entry<MultimapObjectWrapper<K>, V> entry : this.values.entrySet()) {
            converted.put(entry.getKey().get(), entry.getValue());
        }
        return converted;
    }

    private boolean containsKey(Collection<K> keys, MultimapObjectWrapper<K> entry) {
        for (K key : keys) {
            if (!MultimapObjectWrapper.wrappedEquals(entry.get(), key)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        try {
            HashMapBucket that = (HashMapBucket)o;
            if (this.values.size() != that.values.size()) {
                return false;
            }
            for (Map.Entry<MultimapObjectWrapper<K>, V> e : this.values.entrySet()) {
                MultimapObjectWrapper<K> key = e.getKey();
                V value = e.getValue();
                boolean eq = this.equalValues(value, that.values.get(key));
                if (eq) continue;
                return false;
            }
        }
        catch (ClassCastException ignore) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public record HashMapBucketResponse<R, K, V>(R response, HashMapBucket<K, V> bucket) {
    }

    @ProtoTypeId(value=5304)
    static class BucketEntry<K, V> {
        final K key;
        final V value;

        private BucketEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        private BucketEntry(Map.Entry<MultimapObjectWrapper<K>, V> entry) {
            this(entry.getKey().get(), entry.getValue());
        }

        @ProtoFactory
        BucketEntry(MarshallableUserObject<K> wrappedKey, MarshallableUserObject<V> wrappedValue) {
            this(wrappedKey.get(), wrappedValue.get());
        }

        @ProtoField(number=1)
        MarshallableUserObject<K> wrappedKey() {
            return new MarshallableUserObject(this.key);
        }

        public K getKey() {
            return this.key;
        }

        @ProtoField(number=2)
        MarshallableUserObject<V> wrappedValue() {
            return new MarshallableUserObject(this.value);
        }

        public V getValue() {
            return this.value;
        }
    }
}

