/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.Messages;

public class CsvInput
extends BaseStep
implements StepInterface {
    private CsvInputMeta meta;
    private CsvInputData data;

    public CsvInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CsvInputMeta)smi;
        this.data = (CsvInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            if (this.data.filenames == null) {
                this.getFilenamesFromPreviousSteps();
            }
            this.data.parallel = this.meta.isRunningInParallel() && this.data.totalNumberOfSteps > 1;
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (ValueMetaInterface valueMeta : this.data.convertRowMeta.getValueMetaList()) {
                valueMeta.setStorageType(1);
            }
            this.data.filenameFieldIndex = -1;
            if (!Const.isEmpty((String)this.meta.getFilenameField()) && this.meta.isIncludingFilename()) {
                this.data.filenameFieldIndex = this.meta.getInputFields().length;
            }
            this.data.rownumFieldIndex = -1;
            if (!Const.isEmpty((String)this.meta.getRowNumField())) {
                this.data.rownumFieldIndex = this.meta.getInputFields().length;
                if (this.data.filenameFieldIndex >= 0) {
                    ++this.data.rownumFieldIndex;
                }
            }
            if (this.data.parallel) {
                this.prepareToRunInParallel();
            }
            if (!this.openNextFile()) {
                this.setOutputDone();
                return false;
            }
        }
        if (this.data.parallel && this.data.totalBytesRead > this.data.blockToRead) {
            this.setOutputDone();
            return false;
        }
        Object[] outputRowData = this.readOneRow(true);
        if (outputRowData == null) {
            if (this.openNextFile()) {
                return true;
            }
            this.setOutputDone();
            return false;
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("CsvInput.Log.LineNumber", Long.toString(this.getLinesInput())));
        }
        return true;
    }

    private void prepareToRunInParallel() throws KettleException {
        try {
            for (String filename : this.data.filenames) {
                long size = KettleVFS.getFileObject((String)filename).getContent().getSize();
                this.data.fileSizes.add(size);
                this.data.totalFileSize += size;
            }
            this.data.blockToRead = Math.round((double)this.data.totalFileSize / (double)this.data.totalNumberOfSteps);
            this.data.startPosition = this.data.blockToRead * (long)this.data.stepNumber;
            this.data.endPosition = this.data.startPosition + this.data.blockToRead;
            long totalFileSize = 0L;
            for (int i = 0; i < this.data.fileSizes.size(); ++i) {
                long size = this.data.fileSizes.get(i);
                if (this.data.startPosition >= totalFileSize && this.data.startPosition < totalFileSize + size) {
                    this.data.filenr = i;
                    this.data.startFilenr = i;
                    if (this.data.startPosition == 0L) {
                        this.data.bytesToSkipInFirstFile = 0L;
                        break;
                    }
                    this.data.bytesToSkipInFirstFile = this.data.startPosition - totalFileSize;
                    break;
                }
                totalFileSize += size;
            }
            if (this.data.filenames.length > 0) {
                this.logBasic(Messages.getString("CsvInput.Log.ParallelFileNrAndPositionFeedback", this.data.filenames[this.data.filenr], Long.toString(this.data.fileSizes.get(this.data.filenr)), Long.toString(this.data.bytesToSkipInFirstFile), Long.toString(this.data.blockToRead)));
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("CsvInput.Exception.ErrorPreparingParallelRun"), (Throwable)e);
        }
    }

    private void getFilenamesFromPreviousSteps() throws KettleException {
        ArrayList<String> filenames = new ArrayList<String>();
        boolean firstRow = true;
        int index = -1;
        Object[] row = this.getRow();
        while (row != null) {
            if (firstRow) {
                firstRow = false;
                String filenameField = this.environmentSubstitute(this.meta.getFilenameField());
                index = this.getInputRowMeta().indexOfValue(filenameField);
                if (index < 0) {
                    throw new KettleException(Messages.getString("CsvInput.Exception.FilenameFieldNotFound", filenameField));
                }
            }
            String filename = this.getInputRowMeta().getString(row, index);
            filenames.add(filename);
            row = this.getRow();
        }
        this.data.filenames = filenames.toArray(new String[filenames.size()]);
        this.logBasic(Messages.getString("CsvInput.Log.ReadingFromNrFiles", Integer.toString(this.data.filenames.length)));
    }

    private boolean openNextFile() throws KettleException {
        try {
            if (this.data.fc != null) {
                this.data.fc.close();
            }
            if (this.data.fis != null) {
                this.data.fis.close();
            }
            if (this.data.filenr >= this.data.filenames.length) {
                return false;
            }
            FileObject fileObject = KettleVFS.getFileObject((String)this.data.filenames[this.data.filenr]);
            if (!(fileObject instanceof LocalFile)) {
                throw new KettleException(Messages.getString("CsvInput.Log.OnlyLocalFilesAreSupported"));
            }
            if (this.meta.isLazyConversionActive()) {
                this.data.binaryFilename = this.data.filenames[this.data.filenr].getBytes();
            }
            this.data.fis = new FileInputStream(KettleVFS.getFilename((FileObject)fileObject));
            this.data.fc = this.data.fis.getChannel();
            this.data.bb = ByteBuffer.allocateDirect(this.data.preferredBufferSize);
            if (this.data.parallel && this.data.bytesToSkipInFirstFile > 0L) {
                this.data.fc.position(this.data.bytesToSkipInFirstFile);
                this.readOneRow(false);
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, fileObject, this.getTransMeta().getName(), this.toString());
                resultFile.setComment("File was read by a Csv input step");
                this.addResultFile(resultFile);
            }
            ++this.data.filenr;
            if (this.meta.isHeaderPresent() && (!this.data.parallel || this.data.parallel && this.data.bytesToSkipInFirstFile <= 0L)) {
                this.readOneRow(false);
                this.logBasic(Messages.getString("CsvInput.Log.HeaderRowSkipped", this.data.filenames[this.data.filenr - 1]));
            }
            this.data.rowNumber = 1L;
            this.data.bytesToSkipInFirstFile = -1L;
            return true;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private boolean checkBufferSize() throws IOException {
        if (this.data.endBuffer >= this.data.bufferSize) {
            this.data.resizeByteBufferArray();
            int n = this.data.readBufferFromFile();
            return n < 0;
        }
        return false;
    }

    private Object[] readOneRow(boolean doConversions) throws KettleException {
        try {
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            boolean newLineFound = false;
            int newLines = 0;
            while (!newLineFound && outputIndex < this.meta.getInputFields().length) {
                if (this.checkBufferSize()) {
                    if (outputRowData != null && outputIndex > 0) {
                        return outputRowData;
                    }
                    return null;
                }
                boolean delimiterFound = false;
                boolean enclosureFound = false;
                int escapedEnclosureFound = 0;
                while (!delimiterFound) {
                    if (this.data.byteBuffer[this.data.endBuffer] == this.data.delimiter[0]) {
                        delimiterFound = true;
                        continue;
                    }
                    if (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                        ++this.data.endBuffer;
                        ++this.data.totalBytesRead;
                        newLines = 1;
                        if (this.data.endBuffer >= this.data.bufferSize) {
                            this.data.resizeByteBufferArray();
                            this.data.readBufferFromFile();
                        }
                        if (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                            ++this.data.endBuffer;
                            ++this.data.totalBytesRead;
                            newLines = 2;
                            if (this.data.endBuffer >= this.data.bufferSize) {
                                this.data.resizeByteBufferArray();
                                this.data.readBufferFromFile();
                            }
                        }
                        newLineFound = true;
                        delimiterFound = true;
                        continue;
                    }
                    if (this.data.enclosure != null && this.data.byteBuffer[this.data.endBuffer] == this.data.enclosure[0]) {
                        boolean keepGoing;
                        enclosureFound = true;
                        do {
                            if (this.data.increaseEndBuffer()) {
                                enclosureFound = false;
                                break;
                            }
                            boolean bl = keepGoing = this.data.byteBuffer[this.data.endBuffer] != this.data.enclosure[0];
                            if (keepGoing) continue;
                            if (this.data.increaseEndBuffer()) {
                                enclosureFound = false;
                                break;
                            }
                            boolean bl2 = keepGoing = this.data.byteBuffer[this.data.endBuffer] == this.data.enclosure[0];
                            if (!keepGoing) continue;
                            ++escapedEnclosureFound;
                        } while (keepGoing);
                        if (this.data.endBuffer < this.data.bufferSize) continue;
                        newLineFound = true;
                        newLines += 2;
                        break;
                    }
                    ++this.data.endBuffer;
                    ++this.data.totalBytesRead;
                    if (!this.checkBufferSize() || this.data.endBuffer < this.data.bufferSize) continue;
                    newLineFound = true;
                    break;
                }
                int length = this.data.endBuffer - this.data.startBuffer;
                if (newLineFound && (length -= newLines) <= 0) {
                    length = 0;
                }
                if (enclosureFound) {
                    ++this.data.startBuffer;
                    if ((length -= 2) <= 0) {
                        length = 0;
                    }
                }
                if (length <= 0) {
                    length = 0;
                }
                byte[] field = new byte[length];
                System.arraycopy(this.data.byteBuffer, this.data.startBuffer, field, 0, length);
                if (escapedEnclosureFound > 0) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("Escaped enclosures found in " + new String(field));
                    }
                    field = this.data.removeEscapedEnclosures(field, escapedEnclosureFound);
                }
                if (doConversions) {
                    if (this.meta.isLazyConversionActive()) {
                        outputRowData[outputIndex++] = field;
                    } else {
                        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(outputIndex);
                        outputRowData[outputIndex++] = sourceValueMeta.convertBinaryStringToNativeType(field);
                    }
                } else {
                    outputRowData[outputIndex++] = null;
                }
                if (!newLineFound) {
                    ++this.data.totalBytesRead;
                }
                this.data.startBuffer = ++this.data.endBuffer;
            }
            if (!newLineFound && !this.checkBufferSize()) {
                do {
                    ++this.data.endBuffer;
                    ++this.data.totalBytesRead;
                } while (!this.checkBufferSize() && this.data.byteBuffer[this.data.endBuffer] != 10 && this.data.byteBuffer[this.data.endBuffer] != 13);
                if (!this.checkBufferSize()) {
                    while (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                        ++this.data.endBuffer;
                        ++this.data.totalBytesRead;
                        if (!this.checkBufferSize()) continue;
                    }
                }
                this.data.startBuffer = this.data.endBuffer;
            }
            if (this.meta.isIncludingFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                outputRowData[this.data.filenameFieldIndex] = this.meta.isLazyConversionActive() ? (Object)this.data.binaryFilename : this.data.filenames[this.data.filenr - 1];
            }
            if (this.data.isAddingRowNumber) {
                outputRowData[this.data.rownumFieldIndex] = new Long(this.data.rowNumber++);
            }
            this.incrementLinesInput();
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleFileException("Exception reading line using NIO", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CsvInputMeta)smi;
        this.data = (CsvInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.preferredBufferSize = Integer.parseInt(this.environmentSubstitute(this.meta.getBufferSize()));
            if (this.getTransMeta().findNrPrevSteps(this.getStepMeta()) == 0) {
                String filename = this.environmentSubstitute(this.meta.getFilename());
                if (Const.isEmpty((String)filename)) {
                    this.logError(Messages.getString("CsvInput.MissingFilename.Message"));
                    return false;
                }
                this.data.filenames = new String[]{filename};
            } else {
                this.data.filenames = null;
                this.data.filenr = 0;
            }
            this.data.totalBytesRead = 0L;
            this.data.delimiter = this.environmentSubstitute(this.meta.getDelimiter()).getBytes();
            this.data.enclosure = (byte[])(Const.isEmpty((String)this.meta.getEnclosure()) ? null : this.environmentSubstitute(this.meta.getEnclosure()).getBytes());
            this.data.isAddingRowNumber = !Const.isEmpty((String)this.meta.getRowNumField());
            this.data.stopReading = false;
            if (this.meta.isRunningInParallel()) {
                this.data.stepNumber = this.getUniqueStepNrAcrossSlaves();
                this.data.totalNumberOfSteps = this.getUniqueStepCountAcrossSlaves();
                this.data.fileSizes = new ArrayList<Long>();
                this.data.totalFileSize = 0L;
            }
            return true;
        }
        return false;
    }

    public void closeFile() throws KettleException {
        try {
            if (this.data.fc != null) {
                this.data.fc.close();
            }
            if (this.data.fis != null) {
                this.data.fis.close();
            }
        }
        catch (IOException e) {
            throw new KettleException("Unable to close file channel for file '" + this.data.filenames[this.data.filenr - 1], (Throwable)e);
        }
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

