" Name:         shine
" Description:  Light colorscheme inspired by normal text editors.
" Author:       Original author is Yasuhiro Matsumoto <mattn@mail.goo.ne.jp>
" Maintainer:   Original maintainer is Yasuhiro Matsumoto <mattn@mail.goo.ne.jp>
" URL:          https://github.com/vim/colorschemes
" License:      Same as Vim
" Last Change:  2025 Aug 03

" Generated by Colortemplate v3.0.0-beta9

set background=light

hi clear
let g:colors_name = 'shine'

let s:t_Co = has('gui_running') ? 16777216 : str2nr(&t_Co)
let s:tgc = has('termguicolors') && &termguicolors

let g:terminal_ansi_colors = ['#000000', '#8b0000', '#006400', '#ffff00', '#00008b', '#6a0dad', '#008b8b', '#dadada', '#767676', '#ffafaf', '#90ee90', '#ffff60', '#add8e6', '#ff00ff', '#00ffff', '#ffffff']

hi! link CurSearch Search
hi! link CursorLineFold CursorLine
hi! link CursorLineSign CursorLine
hi! link EndOfBuffer NonText
hi! link ErrorMsg Error
hi! link Function Identifier
hi! link LineNrAbove LineNr
hi! link LineNrBelow LineNr
hi! link MessageWindow Pmenu
hi! link Operator Statement
hi! link PopupNotification Todo
hi! link TabPanel Normal
hi! link TabPanelFill EndOfBuffer
hi! link Tag Special
hi! link Terminal Normal

hi Normal guifg=#000000 guibg=#ffffff guisp=NONE gui=NONE ctermfg=16 ctermbg=231 cterm=NONE term=NONE
hi ColorColumn guifg=#000000 guibg=#ffafaf guisp=NONE gui=NONE ctermfg=16 ctermbg=217 cterm=NONE term=reverse
hi Comment guifg=#a8a8a8 guibg=NONE guisp=NONE gui=bold ctermfg=248 ctermbg=NONE cterm=NONE term=bold
hi Conceal guifg=#add8e6 guibg=NONE guisp=NONE gui=NONE ctermfg=153 ctermbg=NONE cterm=NONE term=NONE
hi Constant guifg=#a07070 guibg=NONE guisp=NONE gui=NONE ctermfg=95 ctermbg=NONE cterm=NONE term=NONE
hi Cursor guifg=#ffffff guibg=#000000 guisp=NONE gui=NONE ctermfg=231 ctermbg=16 cterm=NONE term=reverse
hi CursorColumn guifg=NONE guibg=#dadada guisp=NONE gui=NONE ctermfg=NONE ctermbg=253 cterm=NONE term=NONE
hi CursorLine guifg=NONE guibg=#dadada guisp=NONE gui=NONE ctermfg=NONE ctermbg=253 cterm=NONE term=underline
hi CursorLineNr guifg=NONE guibg=#dadada guisp=NONE gui=NONE ctermfg=NONE ctermbg=253 cterm=NONE term=bold
hi DiffAdd guifg=#ffffff guibg=#5f875f guisp=NONE gui=NONE ctermfg=231 ctermbg=65 cterm=NONE term=reverse
hi DiffChange guifg=#ffffff guibg=#5f87af guisp=NONE gui=NONE ctermfg=231 ctermbg=67 cterm=NONE term=NONE
hi DiffDelete guifg=#ffffff guibg=#af5faf guisp=NONE gui=NONE ctermfg=231 ctermbg=133 cterm=NONE term=reverse
hi DiffText guifg=#000000 guibg=#c6c6c6 guisp=NONE gui=NONE ctermfg=16 ctermbg=251 cterm=NONE term=reverse
hi Directory guifg=#008b8b guibg=NONE guisp=NONE gui=bold ctermfg=30 ctermbg=NONE cterm=bold term=NONE
hi Error guifg=#ff0000 guibg=#ffffff guisp=NONE gui=reverse ctermfg=196 ctermbg=231 cterm=reverse term=bold,reverse
hi Float guifg=#a07070 guibg=NONE guisp=NONE gui=bold ctermfg=95 ctermbg=NONE cterm=bold term=NONE
hi FoldColumn guifg=#767676 guibg=NONE guisp=NONE gui=NONE ctermfg=243 ctermbg=NONE cterm=NONE term=NONE
hi Folded guifg=#00008b guibg=#dadada guisp=NONE gui=NONE ctermfg=18 ctermbg=253 cterm=NONE term=NONE
hi Identifier guifg=#008b8b guibg=NONE guisp=NONE gui=NONE ctermfg=30 ctermbg=NONE cterm=NONE term=NONE
hi Ignore guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=NONE
hi IncSearch guifg=#008b8b guibg=#ffff00 guisp=NONE gui=reverse ctermfg=30 ctermbg=226 cterm=reverse term=bold,reverse,underline
hi LineNr guifg=#767676 guibg=NONE guisp=NONE gui=NONE ctermfg=243 ctermbg=NONE cterm=NONE term=NONE
hi MatchParen guifg=#ffffff guibg=#ffafaf guisp=NONE gui=NONE ctermfg=231 ctermbg=217 cterm=NONE term=bold,underline
hi ModeMsg guifg=#000000 guibg=#ffffff guisp=NONE gui=NONE ctermfg=16 ctermbg=231 cterm=NONE term=bold
hi MoreMsg guifg=#006400 guibg=#ffffff guisp=NONE gui=NONE ctermfg=22 ctermbg=231 cterm=NONE term=NONE
hi NonText guifg=#add8e6 guibg=#ffffff guisp=NONE gui=NONE ctermfg=153 ctermbg=231 cterm=NONE term=NONE
hi Number guifg=#a07070 guibg=NONE guisp=NONE gui=bold ctermfg=95 ctermbg=NONE cterm=bold term=NONE
hi Pmenu guifg=#000000 guibg=#a8a8a8 guisp=NONE gui=NONE ctermfg=16 ctermbg=248 cterm=NONE term=reverse
hi PmenuMatch guifg=#ff0000 guibg=#a8a8a8 guisp=NONE gui=NONE ctermfg=196 ctermbg=248 cterm=NONE term=NONE
hi PmenuMatchSel guifg=#ff0000 guibg=#ffff60 guisp=NONE gui=NONE ctermfg=196 ctermbg=228 cterm=NONE term=NONE
hi PmenuSbar guifg=#ffffff guibg=#ffffff guisp=NONE gui=NONE ctermfg=231 ctermbg=231 cterm=NONE term=reverse
hi PmenuSel guifg=#000000 guibg=#ffff60 guisp=NONE gui=NONE ctermfg=16 ctermbg=228 cterm=NONE term=bold
hi PmenuThumb guifg=#767676 guibg=#767676 guisp=NONE gui=NONE ctermfg=243 ctermbg=243 cterm=NONE term=NONE
hi PreProc guifg=#6a0dad guibg=NONE guisp=NONE gui=NONE ctermfg=55 ctermbg=NONE cterm=NONE term=NONE
hi Question guifg=#a07070 guibg=NONE guisp=NONE gui=NONE ctermfg=95 ctermbg=NONE cterm=NONE term=standout
hi QuickFixLine guifg=#000000 guibg=#ff8c00 guisp=NONE gui=NONE ctermfg=16 ctermbg=208 cterm=NONE term=NONE
hi Search guifg=#ffffff guibg=#6a0dad guisp=NONE gui=NONE ctermfg=231 ctermbg=55 cterm=NONE term=reverse
hi SignColumn guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
hi Special guifg=#ff8c00 guibg=NONE guisp=NONE gui=NONE ctermfg=208 ctermbg=NONE cterm=NONE term=NONE
hi SpecialChar guifg=#00008b guibg=NONE guisp=NONE gui=NONE ctermfg=18 ctermbg=NONE cterm=NONE term=NONE
hi SpecialKey guifg=#add8e6 guibg=NONE guisp=NONE gui=NONE ctermfg=153 ctermbg=NONE cterm=NONE term=bold
hi SpellBad guifg=#ff0000 guibg=NONE guisp=#ff0000 gui=undercurl ctermfg=196 ctermbg=NONE cterm=underline term=underline
hi SpellCap guifg=#2e8b57 guibg=NONE guisp=#2e8b57 gui=undercurl ctermfg=29 ctermbg=NONE cterm=underline term=underline
hi SpellLocal guifg=#ff00ff guibg=NONE guisp=#ff00ff gui=undercurl ctermfg=201 ctermbg=NONE cterm=underline term=underline
hi SpellRare guifg=#00008b guibg=NONE guisp=#00008b gui=undercurl ctermfg=18 ctermbg=NONE cterm=underline term=underline
hi Statement guifg=#2e8b57 guibg=NONE guisp=NONE gui=bold ctermfg=29 ctermbg=NONE cterm=bold term=NONE
hi StatusLine guifg=#ffffff guibg=#000000 guisp=NONE gui=bold ctermfg=231 ctermbg=16 cterm=bold term=bold,reverse
hi StatusLineNC guifg=#ffffff guibg=#a8a8a8 guisp=NONE gui=NONE ctermfg=231 ctermbg=248 cterm=NONE term=bold,underline
hi StatusLineTerm guifg=#000000 guibg=#90ee90 guisp=NONE gui=bold ctermfg=16 ctermbg=120 cterm=bold term=bold,reverse
hi StatusLineTermNC guifg=#dadada guibg=#006400 guisp=NONE gui=NONE ctermfg=253 ctermbg=22 cterm=NONE term=bold,underline
hi StorageClass guifg=#ff0000 guibg=NONE guisp=NONE gui=bold ctermfg=196 ctermbg=NONE cterm=bold term=bold
hi TabLine guifg=#000000 guibg=#dadada guisp=NONE gui=underline ctermfg=16 ctermbg=253 cterm=underline term=bold,underline
hi TabLineFill guifg=NONE guibg=NONE guisp=NONE gui=reverse ctermfg=NONE ctermbg=NONE cterm=reverse term=NONE
hi TabLineSel guifg=#000000 guibg=#ffffff guisp=NONE gui=bold ctermfg=16 ctermbg=231 cterm=bold term=bold,reverse
hi Title guifg=#006400 guibg=NONE guisp=NONE gui=bold ctermfg=22 ctermbg=NONE cterm=bold term=NONE
hi Todo guifg=#000000 guibg=#ffff00 guisp=NONE gui=NONE ctermfg=16 ctermbg=226 cterm=NONE term=bold,reverse
hi ToolbarButton guifg=NONE guibg=#a8a8a8 guisp=NONE gui=bold ctermfg=NONE ctermbg=248 cterm=bold term=bold,reverse
hi ToolbarLine guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
hi Type guifg=#2e8b57 guibg=NONE guisp=NONE gui=bold ctermfg=29 ctermbg=NONE cterm=bold term=NONE
hi Underlined guifg=#6a0dad guibg=NONE guisp=NONE gui=underline ctermfg=55 ctermbg=NONE cterm=underline term=underline
hi VertSplit guifg=#a8a8a8 guibg=#a8a8a8 guisp=NONE gui=NONE ctermfg=248 ctermbg=248 cterm=NONE term=NONE
hi Visual guifg=#000000 guibg=#a8a8a8 guisp=NONE gui=NONE ctermfg=16 ctermbg=248 cterm=NONE term=reverse
hi VisualNOS guifg=NONE guibg=NONE guisp=NONE gui=bold ctermfg=NONE ctermbg=NONE cterm=underline term=NONE
hi WarningMsg guifg=#6a0dad guibg=#ffffff guisp=NONE gui=NONE ctermfg=55 ctermbg=231 cterm=NONE term=standout
hi WildMenu guifg=#000000 guibg=#ffff00 guisp=NONE gui=bold ctermfg=16 ctermbg=226 cterm=bold term=bold
hi lCursor guifg=#000000 guibg=#a07070 guisp=NONE gui=NONE ctermfg=16 ctermbg=95 cterm=NONE term=NONE

if s:tgc || s:t_Co >= 256
  finish
endif

if s:t_Co >= 16
  hi Normal ctermfg=black ctermbg=white cterm=NONE
  hi ColorColumn ctermfg=black ctermbg=red cterm=NONE
  hi Comment ctermfg=darkgrey ctermbg=NONE cterm=NONE
  hi Conceal ctermfg=blue ctermbg=NONE cterm=NONE
  hi Constant ctermfg=darkred ctermbg=NONE cterm=NONE
  hi Cursor ctermfg=white ctermbg=black cterm=NONE
  hi CursorColumn ctermfg=NONE ctermbg=NONE cterm=NONE
  hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
  hi CursorLineNr ctermfg=NONE ctermbg=NONE cterm=bold
  hi DiffAdd ctermfg=white ctermbg=darkgreen cterm=NONE
  hi DiffChange ctermfg=white ctermbg=blue cterm=NONE
  hi DiffDelete ctermfg=white ctermbg=magenta cterm=NONE
  hi DiffText ctermfg=black ctermbg=grey cterm=NONE
  hi Directory ctermfg=darkcyan ctermbg=NONE cterm=bold
  hi Error ctermfg=red ctermbg=white cterm=reverse
  hi Float ctermfg=darkred ctermbg=NONE cterm=bold
  hi FoldColumn ctermfg=darkgrey ctermbg=NONE cterm=NONE
  hi Folded ctermfg=darkblue ctermbg=NONE cterm=NONE
  hi Identifier ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
  hi IncSearch ctermfg=darkcyan ctermbg=yellow cterm=reverse
  hi LineNr ctermfg=darkgrey ctermbg=NONE cterm=NONE
  hi MatchParen ctermfg=white ctermbg=red cterm=NONE
  hi ModeMsg ctermfg=black ctermbg=white cterm=NONE
  hi MoreMsg ctermfg=darkgreen ctermbg=white cterm=NONE
  hi NonText ctermfg=blue ctermbg=white cterm=NONE
  hi Number ctermfg=darkred ctermbg=NONE cterm=bold
  hi Pmenu ctermfg=black ctermbg=darkgrey cterm=NONE
  hi PmenuMatch ctermfg=black ctermbg=darkgrey cterm=bold
  hi PmenuMatchSel ctermfg=black ctermbg=yellow cterm=bold
  hi PmenuSbar ctermfg=white ctermbg=white cterm=NONE
  hi PmenuSel ctermfg=black ctermbg=yellow cterm=NONE
  hi PmenuThumb ctermfg=darkgrey ctermbg=darkgrey cterm=NONE
  hi PreProc ctermfg=darkmagenta ctermbg=NONE cterm=NONE
  hi Question ctermfg=darkred ctermbg=NONE cterm=NONE
  hi QuickFixLine ctermfg=black ctermbg=darkyellow cterm=NONE
  hi Search ctermfg=white ctermbg=darkmagenta cterm=NONE
  hi SignColumn ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Special ctermfg=darkyellow ctermbg=NONE cterm=NONE
  hi SpecialChar ctermfg=darkblue ctermbg=NONE cterm=NONE
  hi SpecialKey ctermfg=blue ctermbg=NONE cterm=NONE
  hi SpellBad ctermfg=red ctermbg=NONE cterm=underline
  hi SpellCap ctermfg=darkgreen ctermbg=NONE cterm=underline
  hi SpellLocal ctermfg=magenta ctermbg=NONE cterm=underline
  hi SpellRare ctermfg=darkblue ctermbg=NONE cterm=underline
  hi Statement ctermfg=darkgreen ctermbg=NONE cterm=bold
  hi StatusLine ctermfg=white ctermbg=black cterm=bold
  hi StatusLineNC ctermfg=white ctermbg=darkgrey cterm=NONE
  hi StatusLineTerm ctermfg=black ctermbg=green cterm=bold
  hi StatusLineTermNC ctermfg=grey ctermbg=darkgreen cterm=NONE
  hi StorageClass ctermfg=red ctermbg=NONE cterm=bold
  hi TabLine ctermfg=black ctermbg=grey cterm=underline
  hi TabLineFill ctermfg=NONE ctermbg=NONE cterm=reverse
  hi TabLineSel ctermfg=black ctermbg=white cterm=bold
  hi Title ctermfg=darkgreen ctermbg=NONE cterm=bold
  hi Todo ctermfg=black ctermbg=yellow cterm=NONE
  hi ToolbarButton ctermfg=NONE ctermbg=darkgrey cterm=bold
  hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Type ctermfg=darkgreen ctermbg=NONE cterm=bold
  hi Underlined ctermfg=darkmagenta ctermbg=NONE cterm=underline
  hi VertSplit ctermfg=darkgrey ctermbg=darkgrey cterm=NONE
  hi Visual ctermfg=black ctermbg=darkgrey cterm=NONE
  hi VisualNOS ctermfg=NONE ctermbg=NONE cterm=underline
  hi WarningMsg ctermfg=darkmagenta ctermbg=white cterm=NONE
  hi WildMenu ctermfg=black ctermbg=yellow cterm=bold
  hi lCursor ctermfg=black ctermbg=darkred cterm=NONE
  finish
endif

if s:t_Co >= 8
  hi Normal ctermfg=black ctermbg=grey cterm=NONE
  hi ColorColumn ctermfg=black ctermbg=darkred cterm=NONE
  hi Comment ctermfg=black ctermbg=NONE cterm=bold
  hi Conceal ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Constant ctermfg=darkred ctermbg=NONE cterm=NONE
  hi Cursor ctermfg=white ctermbg=black cterm=NONE
  hi CursorColumn ctermfg=NONE ctermbg=NONE cterm=NONE
  hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
  hi CursorLineNr ctermfg=NONE ctermbg=NONE cterm=bold
  hi DiffAdd ctermfg=white ctermbg=darkgreen cterm=NONE
  hi DiffChange ctermfg=white ctermbg=darkblue cterm=NONE
  hi DiffDelete ctermfg=white ctermbg=darkmagenta cterm=NONE
  hi DiffText ctermfg=black ctermbg=grey cterm=NONE
  hi Directory ctermfg=darkcyan ctermbg=NONE cterm=bold
  hi Error ctermfg=darkred ctermbg=NONE cterm=bold,reverse
  hi Float ctermfg=darkred ctermbg=NONE cterm=bold
  hi FoldColumn ctermfg=grey ctermbg=NONE cterm=bold
  hi Folded ctermfg=darkblue ctermbg=NONE cterm=NONE
  hi Identifier ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
  hi IncSearch ctermfg=darkcyan ctermbg=darkyellow cterm=reverse
  hi LineNr ctermfg=NONE ctermbg=NONE cterm=bold
  hi MatchParen ctermfg=grey ctermbg=darkred cterm=NONE
  hi ModeMsg ctermfg=black ctermbg=NONE cterm=NONE
  hi MoreMsg ctermfg=darkgreen ctermbg=NONE cterm=NONE
  hi NonText ctermfg=darkblue ctermbg=NONE cterm=NONE
  hi Number ctermfg=darkred ctermbg=NONE cterm=bold
  hi Pmenu ctermfg=black ctermbg=darkcyan cterm=NONE
  hi PmenuMatch ctermfg=black ctermbg=darkcyan cterm=bold
  hi PmenuMatchSel ctermfg=black ctermbg=darkyellow cterm=bold
  hi PmenuSbar ctermfg=grey ctermbg=grey cterm=NONE
  hi PmenuSel ctermfg=black ctermbg=darkyellow cterm=NONE
  hi PmenuThumb ctermfg=black ctermbg=black cterm=NONE
  hi PreProc ctermfg=darkmagenta ctermbg=NONE cterm=NONE
  hi Question ctermfg=darkred ctermbg=NONE cterm=NONE
  hi QuickFixLine ctermfg=black ctermbg=darkyellow cterm=NONE
  hi Search ctermfg=grey ctermbg=darkmagenta cterm=NONE
  hi SignColumn ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Special ctermfg=darkyellow ctermbg=NONE cterm=NONE
  hi SpecialChar ctermfg=darkblue ctermbg=NONE cterm=NONE
  hi SpecialKey ctermfg=darkblue ctermbg=NONE cterm=NONE
  hi SpellBad ctermfg=darkred ctermbg=NONE cterm=reverse
  hi SpellCap ctermfg=darkgreen ctermbg=NONE cterm=reverse
  hi SpellLocal ctermfg=darkmagenta ctermbg=NONE cterm=reverse
  hi SpellRare ctermfg=darkblue ctermbg=NONE cterm=reverse
  hi Statement ctermfg=darkgreen ctermbg=NONE cterm=NONE
  hi StatusLine ctermfg=black ctermbg=grey cterm=bold,reverse
  hi StatusLineNC ctermfg=black ctermbg=grey cterm=reverse
  hi StatusLineTerm ctermfg=black ctermbg=darkgreen cterm=bold,reverse
  hi StatusLineTermNC ctermfg=grey ctermbg=darkgreen cterm=reverse
  hi StorageClass ctermfg=darkred ctermbg=NONE cterm=bold
  hi TabLine ctermfg=black ctermbg=grey cterm=reverse
  hi TabLineFill ctermfg=NONE ctermbg=NONE cterm=reverse
  hi TabLineSel ctermfg=grey ctermbg=black cterm=reverse
  hi Title ctermfg=darkgreen ctermbg=NONE cterm=bold
  hi Todo ctermfg=black ctermbg=darkyellow cterm=NONE
  hi ToolbarButton ctermfg=black ctermbg=grey cterm=bold,reverse
  hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Type ctermfg=darkgreen ctermbg=NONE cterm=NONE
  hi Underlined ctermfg=NONE ctermbg=NONE cterm=underline
  hi VertSplit ctermfg=black ctermbg=grey cterm=reverse
  hi Visual ctermfg=NONE ctermbg=NONE cterm=reverse
  hi VisualNOS ctermfg=NONE ctermbg=NONE cterm=underline
  hi WarningMsg ctermfg=darkmagenta ctermbg=NONE cterm=NONE
  hi WildMenu ctermfg=black ctermbg=darkyellow cterm=bold
  hi lCursor ctermfg=black ctermbg=darkred cterm=NONE
  finish
endif

if s:t_Co >= 0
  hi CurSearch term=reverse
  hi CursorIM term=NONE
  hi CursorLineFold term=underline
  hi CursorLineSign term=underline
  hi EndOfBuffer term=NONE
  hi ErrorMsg term=bold,reverse
  hi Function term=NONE
  hi Terminal term=NONE
  finish
endif

" vim: et ts=8 sw=2 sts=2
