/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.preparator.Preparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKIdentityPreparator
extends Preparator<PSKIdentity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PSKIdentity pskIdentity;

    public PSKIdentityPreparator(Chooser chooser, PSKIdentity pskIdentity) {
        super(chooser, pskIdentity);
        this.pskIdentity = pskIdentity;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing PSK identity");
        this.prepareIdentity();
        this.prepareObfuscatedTicketAge();
    }

    private void prepareIdentity() {
        this.pskIdentity.setIdentity(this.pskIdentity.getIdentityConfig());
        this.pskIdentity.setIdentityLength(((byte[])this.pskIdentity.getIdentity().getValue()).length);
    }

    private void prepareObfuscatedTicketAge() {
        this.pskIdentity.setObfuscatedTicketAge(this.getObfuscatedTicketAge(this.pskIdentity.getTicketAgeAddConfig(), this.pskIdentity.getTicketAgeConfig()));
    }

    private byte[] getObfuscatedTicketAge(byte[] ticketAgeAdd, String ticketAge) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        LocalDateTime ticketDate = LocalDateTime.parse(ticketAge, dateTimeFormatter);
        BigInteger difference = BigInteger.valueOf(Duration.between(ticketDate, LocalDateTime.now()).toMillis());
        BigInteger addValue = BigInteger.valueOf(ArrayConverter.bytesToLong((byte[])ticketAgeAdd));
        BigInteger mod = BigInteger.valueOf(2L).pow(32);
        difference = difference.add(addValue);
        difference = difference.mod(mod);
        byte[] obfTicketAge = ArrayConverter.longToBytes((long)difference.longValue(), (int)4);
        LOGGER.debug("Calculated ObfuscatedTicketAge: " + ArrayConverter.bytesToHexString((byte[])obfTicketAge));
        return obfTicketAge;
    }
}

