/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image;

import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.FieldAccessor;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.ImageDetailProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.InstanceBuilder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.InstanceBuilderRegistry;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class ImageBuilder {
    static final Logger LOGGER = Logger.getLogger(ImageDetailProvider.class.getName());
    private static final InstanceBuilder<String> TOOKIT_IMAGE_STRING_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<String>(String.class, "imagerep", "bimage");
    private static final InstanceBuilder<Image> TOOKIT_IMAGE_IMAGE_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<Image>(Image.class, "imagerep", "bimage");
    private static final InstanceBuilder<String> IMAGE_ICON_STRING_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<String>(String.class, "image");
    private static final InstanceBuilder<Image> IMAGE_ICON_IMAGE_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<Image>(Image.class, "image");
    private static final InstanceBuilder<String> BUFFERED_IMAGE_STRING_BUILDER = new InstanceBuilder<String>(String.class){

        @Override
        public String convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            Instance raster = fa.getInstance(instance, "raster", WritableRaster.class, true);
            int width = fa.getInt(raster, "width");
            int height = fa.getInt(raster, "height");
            Instance colorModel = fa.getInstance(instance, "colorModel", ColorModel.class, true);
            int color_count = 0;
            if (FieldAccessor.isInstanceOf(colorModel, IndexColorModel.class)) {
                color_count = DetailsUtils.getIntFieldValue(colorModel, "map_size", 0);
            }
            if (color_count > 0) {
                return Bundle.ImageDetailProvider_ImageDescrColors(width, height, color_count);
            }
            return Bundle.ImageDetailProvider_ImageDescr(width, height);
        }
    };
    private static final InstanceBuilder<Image> BUFFERED_IMAGE_IMAGE_BUILDER = new InstanceBuilder<Image>(Image.class){

        @Override
        public Image convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            try {
                int imageType = fa.getInt(instance, "imageType");
                WritableRaster raster = fa.build(instance, "raster", WritableRaster.class, false);
                ColorModel cm = fa.build(instance, "colorModel", ColorModel.class, false);
                BufferedImage result = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
                result.setData(raster);
                return result;
            }
            catch (FieldAccessor.InvalidFieldException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new FieldAccessor.InvalidFieldException("unable to recreate raster: {0}", ex.getMessage()).initCause(ex);
            }
        }
    };
    private static final InstanceBuilder<ColorModel> INDEX_COLOR_MODEL_BUILDER = new InstanceBuilder<ColorModel>(ColorModel.class){

        @Override
        public ColorModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int bits = fa.getInt(instance, "pixel_bits");
            int[] cmap = fa.getIntArray(instance, "rgb", false);
            int size = fa.getInt(instance, "map_size");
            int trans = fa.getInt(instance, "transparent_index");
            int transferType = fa.getInt(instance, "transferType");
            return new IndexColorModel(bits, size, cmap, 0, true, trans, transferType);
        }
    };
    private static final InstanceBuilder<ColorModel> DIRECT_COLOR_MODEL_BUILDER = new InstanceBuilder<ColorModel>(ColorModel.class){

        @Override
        public ColorModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int bits = fa.getInt(instance, "pixel_bits");
            int rmask = fa.getInt(instance, "red_mask");
            int gmask = fa.getInt(instance, "green_mask");
            int bmask = fa.getInt(instance, "blue_mask");
            int amask = fa.getInt(instance, "alpha_mask");
            boolean ap = fa.getBoolean(instance, "isAlphaPremultiplied");
            int transferType = fa.getInt(instance, "transferType");
            return new DirectColorModel(ColorSpace.getInstance(1000), bits, rmask, gmask, bmask, amask, ap, transferType);
        }
    };
    private static final InstanceBuilder<ColorModel> COMPONENT_COLOR_MODEL_BUILDER = new InstanceBuilder<ColorModel>(ColorModel.class){

        @Override
        public ColorModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int[] bits = fa.getIntArray(instance, "nBits", false);
            int transparency = fa.getInt(instance, "transparency");
            boolean hasAlpha = fa.getBoolean(instance, "supportsAlpha");
            boolean ap = fa.getBoolean(instance, "isAlphaPremultiplied");
            int transferType = fa.getInt(instance, "transferType");
            return new ComponentColorModel(ColorSpace.getInstance(1000), bits, hasAlpha, ap, transparency, transferType);
        }
    };
    private static final InstanceBuilder<ColorSpace> DEFAULT_COLOR_SPACE_BUILDER = new InstanceBuilder<ColorSpace>(ColorSpace.class){

        @Override
        public ColorSpace convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            return ColorSpace.getInstance(1000);
        }
    };
    private static final InstanceBuilder<WritableRaster> WRITABLE_RASTER_BUILDER = new InstanceBuilder<WritableRaster>(WritableRaster.class){

        @Override
        public WritableRaster convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            WritableRaster parent = accessor.build(instance, "parent", WritableRaster.class, true);
            if (parent == null) {
                DataBuffer dataBuffer = accessor.build(instance, "dataBuffer", DataBuffer.class, false);
                SampleModel sampleModel = accessor.build(instance, "sampleModel", SampleModel.class, false);
                int tx = accessor.getInt(instance, "sampleModelTranslateX");
                int ty = accessor.getInt(instance, "sampleModelTranslateY");
                return Raster.createWritableRaster(sampleModel, dataBuffer, new Point(tx, ty));
            }
            int width = accessor.getInt(instance, "width");
            int height = accessor.getInt(instance, "height");
            int minX = accessor.getInt(instance, "minX");
            int minY = accessor.getInt(instance, "minY");
            int tx = accessor.getInt(instance, "sampleModelTranslateX");
            int ty = accessor.getInt(instance, "sampleModelTranslateY");
            int px = parent.getSampleModelTranslateX();
            int py = parent.getSampleModelTranslateY();
            return parent.createWritableChild(minX, minY, width, height, tx - px + minX, ty - py + minY, null);
        }
    };
    private static final InstanceBuilder<SampleModel> SPP_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int width = fa.getInt(instance, "width");
            int height = fa.getInt(instance, "height");
            int dataType = fa.getInt(instance, "dataType");
            int scanlineStride = fa.getInt(instance, "scanlineStride");
            int[] bitMasks = fa.getIntArray(instance, "bitMasks", false);
            return new SinglePixelPackedSampleModel(dataType, width, height, scanlineStride, bitMasks);
        }
    };
    private static final InstanceBuilder<SampleModel> PI_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int width = fa.getInt(instance, "width");
            int height = fa.getInt(instance, "height");
            int dataType = fa.getInt(instance, "dataType");
            int pixelStride = fa.getInt(instance, "pixelStride");
            int scanlineStride = fa.getInt(instance, "scanlineStride");
            int[] bandOffsets = fa.getIntArray(instance, "bandOffsets", false);
            return new PixelInterleavedSampleModel(dataType, width, height, pixelStride, scanlineStride, bandOffsets);
        }
    };
    private static final InstanceBuilder<SampleModel> B_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int width = fa.getInt(instance, "width");
            int height = fa.getInt(instance, "height");
            int dataType = fa.getInt(instance, "dataType");
            int scanlineStride = fa.getInt(instance, "scanlineStride");
            int[] bankIndices = fa.getIntArray(instance, "bankIndices", false);
            int[] bandOffsets = fa.getIntArray(instance, "bandOffsets", false);
            return new BandedSampleModel(dataType, width, height, scanlineStride, bankIndices, bandOffsets);
        }
    };
    private static final InstanceBuilder<SampleModel> MPP_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int width = fa.getInt(instance, "width");
            int height = fa.getInt(instance, "height");
            int dataType = fa.getInt(instance, "dataType");
            int scanlineStride = fa.getInt(instance, "scanlineStride");
            int numberOfBits = fa.getInt(instance, "numberOfBits");
            int dataBitOffset = fa.getInt(instance, "dataBitOffset");
            return new MultiPixelPackedSampleModel(dataType, width, height, numberOfBits, scanlineStride, dataBitOffset);
        }
    };
    private static final InstanceBuilder<DataBuffer> INT_DATA_BUFFER_BUILDER = new InstanceBuilder<DataBuffer>(DataBuffer.class){

        @Override
        public DataBuffer convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int size = fa.getInt(instance, "size");
            int[] offsets = fa.getIntArray(instance, "offsets", false);
            int[][] bankdata = fa.getIntArray2(instance, "bankdata", false);
            return new DataBufferInt(bankdata, size, offsets);
        }
    };
    private static final InstanceBuilder<DataBuffer> BYTE_DATA_BUFFER_BUILDER = new InstanceBuilder<DataBuffer>(DataBuffer.class){

        @Override
        public DataBuffer convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int size = fa.getInt(instance, "size");
            int[] offsets = fa.getIntArray(instance, "offsets", false);
            byte[][] bankdata = fa.getByteArray2(instance, "bankdata", false);
            return new DataBufferByte(bankdata, size, offsets);
        }
    };
    private static final InstanceBuilder<DataBuffer> USHORT_DATA_BUFFER_BUILDER = new InstanceBuilder<DataBuffer>(DataBuffer.class){

        @Override
        public DataBuffer convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            int size = fa.getInt(instance, "size");
            int[] offsets = fa.getIntArray(instance, "offsets", false);
            short[][] bankdata = fa.getShortArray2(instance, "bankdata", false);
            return new DataBufferUShort(bankdata, size, offsets);
        }
    };
    static final InstanceBuilderRegistry BUILDERS = new InstanceBuilderRegistry();

    public static Image buildImage(Instance instance) {
        try {
            return ImageBuilder.buildImageInternal(instance);
        }
        catch (FieldAccessor.InvalidFieldException ex) {
            LOGGER.log(Level.FINE, "Unable to create image for instance, error: {0}", ex.getMessage());
            return null;
        }
    }

    static Image buildImageInternal(Instance instance) throws FieldAccessor.InvalidFieldException {
        InstanceBuilder<Image> builder = BUILDERS.getBuilder(instance, Image.class);
        if (builder == null) {
            throw new FieldAccessor.InvalidFieldException("Unable to get Image builder for {0}#{1}", instance.getJavaClass().getName(), instance.getInstanceNumber());
        }
        return builder.convert(new FieldAccessor(BUILDERS), instance);
    }

    static {
        BUILDERS.register(ColorSpace.class, true, DEFAULT_COLOR_SPACE_BUILDER);
        BUILDERS.register(IndexColorModel.class, true, INDEX_COLOR_MODEL_BUILDER);
        BUILDERS.register(ComponentColorModel.class, true, COMPONENT_COLOR_MODEL_BUILDER);
        BUILDERS.register(DirectColorModel.class, true, DIRECT_COLOR_MODEL_BUILDER);
        BUILDERS.register(SinglePixelPackedSampleModel.class, false, SPP_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(PixelInterleavedSampleModel.class, false, PI_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(BandedSampleModel.class, false, B_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(MultiPixelPackedSampleModel.class, false, MPP_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(DataBufferInt.class, false, INT_DATA_BUFFER_BUILDER);
        BUILDERS.register(DataBufferByte.class, false, BYTE_DATA_BUFFER_BUILDER);
        BUILDERS.register(DataBufferUShort.class, false, USHORT_DATA_BUFFER_BUILDER);
        BUILDERS.register(WritableRaster.class, true, WRITABLE_RASTER_BUILDER);
        BUILDERS.register("sun.awt.image.ToolkitImage+", TOOKIT_IMAGE_STRING_BUILDER);
        BUILDERS.register("sun.awt.image.ToolkitImage+", TOOKIT_IMAGE_IMAGE_BUILDER);
        BUILDERS.register(ImageIcon.class, true, IMAGE_ICON_STRING_BUILDER);
        BUILDERS.register(ImageIcon.class, true, IMAGE_ICON_IMAGE_BUILDER);
        BUILDERS.register(BufferedImage.class, true, BUFFERED_IMAGE_STRING_BUILDER);
        BUILDERS.register(BufferedImage.class, true, BUFFERED_IMAGE_IMAGE_BUILDER);
    }
}

