/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.xy;

import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ItemPainter;
import org.graalvm.visualvm.lib.charts.xy.XYItem;

public interface XYItemPainter
extends ItemPainter {
    public static final int TYPE_ABSOLUTE = 0;
    public static final int TYPE_RELATIVE = 1;

    public double getItemView(double var1, XYItem var3, ChartContext var4);

    public double getItemValue(double var1, XYItem var3, ChartContext var4);

    public double getItemValueScale(XYItem var1, ChartContext var2);

    public static abstract class Abstract
    implements XYItemPainter {
        @Override
        public double getItemView(double dataY, XYItem item, ChartContext context) {
            return context.getViewY(dataY);
        }

        @Override
        public double getItemValue(double viewY, XYItem item, ChartContext context) {
            return context.getDataY(viewY);
        }

        @Override
        public double getItemValueScale(XYItem item, ChartContext context) {
            double scale = context.getViewHeight(1.0);
            if (scale <= 0.0) {
                scale = -1.0;
            }
            return scale;
        }
    }
}

