/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeUpdateInfo;

public final class TypeBoundInvokeUse
implements ITypeBoundDynamic {
    private final RootNode root;
    private final BaseInvokeNode invokeNode;
    private final RegisterArg arg;
    private final ArgType genericArgType;

    public TypeBoundInvokeUse(RootNode root, BaseInvokeNode invokeNode, RegisterArg arg, ArgType genericArgType) {
        this.root = root;
        this.invokeNode = invokeNode;
        this.arg = arg;
        this.genericArgType = genericArgType;
    }

    @Override
    public BoundEnum getBound() {
        return BoundEnum.USE;
    }

    @Override
    public ArgType getType(TypeUpdateInfo updateInfo) {
        return this.getArgType(updateInfo.getType(this.invokeNode.getInstanceArg()), updateInfo.getType(this.arg));
    }

    @Override
    public ArgType getType() {
        return this.getArgType(this.invokeNode.getInstanceArg().getType(), this.arg.getType());
    }

    private ArgType getArgType(ArgType instanceType, ArgType argType) {
        ArgType resultGeneric = this.root.getTypeUtils().replaceClassGenerics(instanceType, this.genericArgType);
        if (resultGeneric != null) {
            return resultGeneric;
        }
        return argType;
    }

    @Override
    public RegisterArg getArg() {
        return this.arg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeBoundInvokeUse that = (TypeBoundInvokeUse)o;
        return this.invokeNode.equals(that.invokeNode);
    }

    public int hashCode() {
        return this.invokeNode.hashCode();
    }

    public String toString() {
        return "InvokeAssign{" + this.invokeNode.getCallMth().getShortId() + ", argType=" + this.genericArgType + ", currentType=" + this.getType() + ", instanceArg=" + this.invokeNode.getInstanceArg() + '}';
    }
}

