/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.metadata.impl;

import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.core.utils.Utils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class CodeMetadataStorage
implements ICodeMetadata {
    private final Map<Integer, Integer> lines;
    private final NavigableMap<Integer, ICodeAnnotation> navMap;

    public static ICodeMetadata build(Map<Integer, Integer> lines, Map<Integer, ICodeAnnotation> map) {
        if (map.isEmpty() && lines.isEmpty()) {
            return ICodeMetadata.EMPTY;
        }
        Comparator<Integer> reverseCmp = Comparator.comparingInt(Integer::intValue).reversed();
        TreeMap<Integer, ICodeAnnotation> navMap = new TreeMap<Integer, ICodeAnnotation>(reverseCmp);
        navMap.putAll(map);
        return new CodeMetadataStorage(lines, navMap);
    }

    public static ICodeMetadata empty() {
        return new CodeMetadataStorage(Collections.emptyMap(), Collections.emptyNavigableMap());
    }

    private CodeMetadataStorage(Map<Integer, Integer> lines, NavigableMap<Integer, ICodeAnnotation> navMap) {
        this.lines = lines;
        this.navMap = navMap;
    }

    @Override
    public ICodeAnnotation getAt(int position) {
        return (ICodeAnnotation)this.navMap.get(position);
    }

    @Override
    @Nullable
    public ICodeAnnotation getClosestUp(int position) {
        Map.Entry<Integer, ICodeAnnotation> entryBefore = this.navMap.higherEntry(position);
        return entryBefore != null ? entryBefore.getValue() : null;
    }

    @Override
    @Nullable
    public ICodeAnnotation searchUp(int position, ICodeAnnotation.AnnType annType) {
        for (ICodeAnnotation v : this.navMap.tailMap(position, true).values()) {
            if (v.getAnnType() != annType) continue;
            return v;
        }
        return null;
    }

    @Override
    @Nullable
    public ICodeAnnotation searchUp(int position, int limitPos, ICodeAnnotation.AnnType annType) {
        for (ICodeAnnotation v : this.navMap.subMap(position, true, limitPos, true).values()) {
            if (v.getAnnType() != annType) continue;
            return v;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T searchUp(int startPos, BiFunction<Integer, ICodeAnnotation, T> visitor) {
        for (Map.Entry entry : this.navMap.tailMap(startPos, true).entrySet()) {
            T value = visitor.apply((Integer)entry.getKey(), (ICodeAnnotation)entry.getValue());
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T searchDown(int startPos, BiFunction<Integer, ICodeAnnotation, T> visitor) {
        NavigableMap<Integer, ICodeAnnotation> map = this.navMap.headMap(startPos, true).descendingMap();
        for (Map.Entry entry : map.entrySet()) {
            T value = visitor.apply((Integer)entry.getKey(), (ICodeAnnotation)entry.getValue());
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public ICodeNodeRef getNodeAt(int position) {
        int nesting = 0;
        for (ICodeAnnotation ann : this.navMap.tailMap(position, true).values()) {
            switch (ann.getAnnType()) {
                case END: {
                    ++nesting;
                    break;
                }
                case DECLARATION: {
                    ICodeNodeRef node = ((NodeDeclareRef)ann).getNode();
                    ICodeAnnotation.AnnType nodeType = node.getAnnType();
                    if (nodeType != ICodeAnnotation.AnnType.CLASS && nodeType != ICodeAnnotation.AnnType.METHOD) break;
                    if (nesting == 0) {
                        return node;
                    }
                    --nesting;
                }
            }
        }
        return null;
    }

    @Override
    public ICodeNodeRef getNodeBelow(int position) {
        for (ICodeAnnotation ann : this.navMap.headMap(position, true).descendingMap().values()) {
            ICodeNodeRef node;
            ICodeAnnotation.AnnType nodeType;
            if (ann.getAnnType() != ICodeAnnotation.AnnType.DECLARATION || (nodeType = (node = ((NodeDeclareRef)ann).getNode()).getAnnType()) != ICodeAnnotation.AnnType.CLASS && nodeType != ICodeAnnotation.AnnType.METHOD) continue;
            return node;
        }
        return null;
    }

    public NavigableMap<Integer, ICodeAnnotation> getAsMap() {
        return this.navMap;
    }

    @Override
    public Map<Integer, Integer> getLineMapping() {
        return this.lines;
    }

    public String toString() {
        return "CodeMetadata{\nlines=" + this.lines + "\nannotations=\n " + Utils.listToString(this.navMap.descendingMap().entrySet(), "\n ") + "\n}";
    }
}

