/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import jadx.api.ICodeCache;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.impl.NoOpCodeCache;
import jadx.api.impl.SimpleCodeWriter;
import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.cli.SingleClassMode;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import jadx.core.utils.files.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxCLI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxCLI.class);

    public static void main(String[] args) {
        int result = 0;
        try {
            result = JadxCLI.execute(args);
        }
        catch (JadxArgsValidateException e) {
            LOG.error("Incorrect arguments: {}", (Object)e.getMessage());
            result = 1;
        }
        catch (Throwable e) {
            LOG.error("Process error:", e);
            result = 1;
        }
        finally {
            FileUtils.deleteTempRootDir();
            System.exit(result);
        }
    }

    public static int execute(String[] args) {
        JadxCLIArgs jadxArgs = new JadxCLIArgs();
        if (jadxArgs.processArgs(args)) {
            return JadxCLI.processAndSave(jadxArgs);
        }
        return 0;
    }

    private static int processAndSave(JadxCLIArgs cliArgs) {
        LogHelper.initLogLevel(cliArgs);
        LogHelper.setLogLevelsForLoadingStage();
        JadxArgs jadxArgs = cliArgs.toJadxArgs();
        jadxArgs.setCodeCache((ICodeCache)new NoOpCodeCache());
        jadxArgs.setCodeWriterProvider(SimpleCodeWriter::new);
        try (JadxDecompiler jadx = new JadxDecompiler(jadxArgs);){
            int errorsCount;
            jadx.load();
            if (JadxCLI.checkForErrors(jadx)) {
                int n = 1;
                return n;
            }
            LogHelper.setLogLevelsForDecompileStage();
            if (!SingleClassMode.process(jadx, cliArgs)) {
                JadxCLI.save(jadx);
            }
            if ((errorsCount = jadx.getErrorsCount()) != 0) {
                jadx.printErrorsReport();
                LOG.error("finished with errors, count: {}", (Object)errorsCount);
            } else {
                LOG.info("done");
            }
        }
        return 0;
    }

    private static boolean checkForErrors(JadxDecompiler jadx) {
        if (jadx.getRoot().getClasses().isEmpty()) {
            if (jadx.getArgs().isSkipResources()) {
                LOG.error("Load failed! No classes for decompile!");
                return true;
            }
            if (!jadx.getArgs().isSkipSources()) {
                LOG.warn("No classes to decompile; decoding resources only");
                jadx.getArgs().setSkipSources(true);
            }
        }
        if (jadx.getErrorsCount() > 0) {
            LOG.error("Load with errors! Check log for details");
            return false;
        }
        return false;
    }

    private static void save(JadxDecompiler jadx) {
        if (LogHelper.getLogLevel() == LogHelper.LogLevelEnum.QUIET) {
            jadx.save();
        } else {
            jadx.save(500, (done, total) -> {
                int progress = (int)((double)done * 100.0 / (double)total);
                System.out.printf("INFO  - progress: %d of %d (%d%%)\r", done, total, progress);
            });
            System.out.print("                                                             \r");
        }
    }
}

