/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common;

import io.github.skylot.raung.common.AnnotationType;
import io.github.skylot.raung.common.DirectiveScope;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum Directive {
    VERSION(".version", 1),
    CLASS(".class", 1),
    SUPER(".super", 1),
    IMPLEMENTS(".implements", 1),
    SOURCE(".source", 1),
    SIGNATURE(".signature", 7),
    INNERCLASS(".innerclass", 1),
    OUTERCLASS(".outerclass", 1),
    NEST(".nest", 1),
    AUTO(".auto", 1),
    FIELD(".field", 1),
    METHOD(".method", 1),
    ENUM(".enum", 1),
    ANNOTATION(".annotation", 7),
    TYPE_ANNOTATION('.' + AnnotationType.TYPE.getName(), 7),
    INSN_ANNOTATION('.' + AnnotationType.INSN.getName(), 4),
    PARAM_ANNOTATION('.' + AnnotationType.PARAM.getName(), 4),
    ANNOTATION_DEFAULT_VALUE('.' + AnnotationType.DEFAULT.getName(), 4),
    MAX(".max", 4),
    THROW(".throw", 4),
    LINE(".line", 4),
    LOCAL(".local", 4),
    STACK(".stack", 4),
    CATCH(".catch", 4),
    END(".end", 7);

    private final String token;
    private final int scope;
    private static final Map<String, Directive> TOKENS_MAP;

    private Directive(String token, int scope) {
        this.token = token;
        this.scope = scope;
    }

    public String token() {
        return this.token;
    }

    @Nullable
    public static Directive parseToken(String str) {
        return TOKENS_MAP.get(str);
    }

    public boolean isAllowedInField() {
        return DirectiveScope.hasField(this.scope);
    }

    static {
        Directive[] values = Directive.values();
        HashMap<String, Directive> map = new HashMap<String, Directive>(values.length);
        for (Directive value : values) {
            map.put(value.token, value);
        }
        TOKENS_MAP = map;
    }
}

