/*
    This file is part of the KDE libraries
    Copyright (C) 1998 Jrgen Hochwald (juergen.hochwald@privat.kkf.net

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.*/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qframe.h>
#include <qgroupbox.h>
#include <kcolordlg.h>
#include <kapp.h>
#include <qbuttongroup.h>
#include <ktmainwindow.h>
#include "kwrdlg.h"

WrTestDlg *DLG;

WrTestDlg::WrTestDlg(QWidget* /*parent=0*/, const char* name=0):
     KTMainWindow (name)
{
int Lauf;

   resize(300,390);
   setFixedSize(300,390);

   QLabel *DetailLab = new QLabel("Detaillevel", this);
   DetailLab->setGeometry(10,10,80,20);
   DetailSpin = new QSpinBox(this);
   DetailSpin->setGeometry(100,10,50,22);
   DetailSpin->setRange(1,4);
   DetailSpin->setValue(2);
   
   QLabel *WidthLab = new QLabel("Width (*0.01)",this);
   WidthLab->setGeometry(10,40,80,20);
   WidthSpin = new QSpinBox(this);
   WidthSpin->setGeometry(100,40,50,22);
   WidthSpin->setRange(3,100);
   WidthSpin->setValue(20);
   
   QLabel *DirLab = new QLabel("Wind Direction",this);
   DirLab->setGeometry(10,70,90,20);
   DirEdit = new QLineEdit(this);
   DirEdit->setGeometry(100,70,60,22);
   DirEdit->setText("0");

   QGroupBox* DirTextGrp = new QGroupBox(this);
   DirTextGrp->setGeometry(180,5,100,90);
   QStrList *SL1 = new QStrList();
   for(Lauf=0; Lauf<33;Lauf++)
      SL1->append(KWindRose::getDirText(Lauf));
   DirTextSpin = new KListSpinBox(SL1,DirTextGrp);
   DirTextSpin->setGeometry(10,5,80,22);
   DirTextSpin->setEditable(TRUE);
   QPushButton* DirSetIndexBtn= new QPushButton("Set(Index)", DirTextGrp);
   DirSetIndexBtn->setGeometry(10,35,80,20);
   connect(DirSetIndexBtn,SIGNAL(clicked()),SLOT(DirSetIndexBtnClick()));
   QPushButton* DirSetTextBtn= new QPushButton("Set(Text)", DirTextGrp);
   DirSetTextBtn->setGeometry(10,60,80,20);
   connect(DirSetTextBtn,SIGNAL(clicked()),SLOT(DirSetTextBtnClick()));
   
   QLabel *Col1Lab = new QLabel("Dark part of windrose",this);
   Col1Lab->setGeometry(100,100,150,20);
   Col1Btn = new QPushButton("Col1",this);
   Col1Btn->setGeometry(10,100,50,25);
   Col1Btn->setPalette(QPalette(qRgb(128,128,255)));

   QLabel *Col2Lab = new QLabel("Light part of windrose",this);
   Col2Lab->setGeometry(100,125,150,20);
   Col2Btn = new QPushButton("Col2",this);
   Col2Btn->setGeometry(10,125,50,25);
   Col2Btn->setPalette(QPalette(qRgb(192,255,255)));

   QLabel *Col3Lab = new QLabel("Dark part of arrow",this);
   Col3Lab->setGeometry(100,150,150,20);
   Col3Btn = new QPushButton("Col3",this);
   Col3Btn->setGeometry(10,150,50,25);
   Col3Btn->setPalette(QPalette(qRgb(16,16,16)));

   QLabel *Col4Lab = new QLabel("Light part of arrow",this);
   Col4Lab->setGeometry(100,175,150,20);
   Col4Btn = new QPushButton("Col4",this);
   Col4Btn->setGeometry(10,175,50,25);
   Col4Btn->setPalette(QPalette(qRgb(64,64,64)));

   QLabel *Col5Lab = new QLabel("Widget background",this);
   Col5Lab->setGeometry(100,210,150,20);
   Col5Btn = new QPushButton("Col5",this);
   Col5Btn->setGeometry(10,210,50,25);
//   Col5Btn->setPalette(WR->backgroundColor());
   connect(Col1Btn, SIGNAL(clicked()), SLOT(Col1BtnClick()) );
   connect(Col2Btn, SIGNAL(clicked()), SLOT(Col2BtnClick()) );
   connect(Col3Btn, SIGNAL(clicked()), SLOT(Col3BtnClick()) );
   connect(Col4Btn, SIGNAL(clicked()), SLOT(Col4BtnClick()) );
   connect(Col5Btn, SIGNAL(clicked()), SLOT(Col5BtnClick()) );

   QLabel *ArrowLab = new QLabel("Arrow type", this);
   ArrowLab->setGeometry(10,240,90,20);
   QStrList *SL = new QStrList();
   SL->append("Arrow 1");
   SL->append("Arrow 2");
   ArrowSpin = new KListSpinBox(SL,this);
   ArrowSpin->setGeometry(100,240,80,22);

   EditCheck = new QCheckBox("Editable", this);
   EditCheck->setGeometry(20,270,200,20);
   EditCheck->setChecked(TRUE);

   QLabel *ResLab = new QLabel("Resolution",this);
   ResLab->setGeometry(20,300,80,20);
   ResEdit = new QLineEdit(this);
   ResEdit->setGeometry(100,300,80,22);
   ResEdit->setText("1");

   QGroupBox* ValidGrp = new QButtonGroup("Vaild Setting",this);
   ValidGrp->setGeometry(195,240,100,90);
   ValidRad = new QRadioButton("Valid",ValidGrp);
   ValidRad->setGeometry(10,15,80,20);
   NodataRad = new QRadioButton("No Data",ValidGrp);
   NodataRad->setGeometry(10,35,80,20);
   InvalidRad = new QRadioButton("Invalid",ValidGrp);
   InvalidRad->setGeometry(10,55,80,20);
   ValidRad->setChecked(TRUE);

   ApplyBtn = new QPushButton(klocale->translate("Apply"), this, "ApplyBtn");
   ApplyBtn->setGeometry(width()-100,height()-50,80,30);
   connect(ApplyBtn, SIGNAL(clicked()), SLOT(ApplyBtnClick()) );

   TestBtn = new QPushButton(klocale->translate("40*40"), this, "TestBtn");
   TestBtn->setGeometry(30,height()-50,80,30);
   connect(TestBtn, SIGNAL(clicked()), SLOT(TestBtnClick()) );

}

void WrTestDlg::ApplyBtnClick() {
float f=0.0;
QString Strg;
bool ok;

   //debug("ApplyBtnClick");
   WR->setDetails(DetailSpin->value());
   WR->setRoseWidth(0.01*WidthSpin->value());
   Strg=DirEdit->text();
   f=Strg.toDouble(&ok);
   if (ok)
      WR->setDirection(f);
   //WR->setDirection(DirSpin->value());
   WR->setColors(Col1Btn->backgroundColor(),Col2Btn->backgroundColor(),Col3Btn->backgroundColor(),Col4Btn->backgroundColor());
   WR->setPalette(QPalette(Col5Btn->backgroundColor()));
   //WR->setFrameStyle(QFrame::NoFrame);
   WR->setArrowType(ArrowSpin->getIndex());
   WR->setEditable(EditCheck->isChecked());
   Strg = ResEdit->text();
   f = Strg.toDouble(&ok);
   if (ok) 
      WR->setResolution(f);
   //debug("Strg=%s   f=%0.2f,  ok=%d,  Res=%0.2f",Strg.data(),f,ok,WR->getResolution());
   //debug("Arrow %d",ArrowSpin->getIndex());
   if (ValidRad->isChecked())
     WR->setValid(KWR_VALID);
   if (NodataRad->isChecked())
     WR->setValid(KWR_NODIR);
   if (InvalidRad->isChecked())
     WR->setValid(KWR_INVALID);
}

void WrTestDlg::TestBtnClick() {
   //debug("TestBtnClick");
   WR->resize(40,40);
}

void WrTestDlg::Col1BtnClick() {
KColorDialog CDlg(this,"FARBE WHLEN",TRUE);

   //debug("Col1BtnClick");
   CDlg.setColor(Col1Btn->backgroundColor());
   if (CDlg.exec()) {
      Col1Btn->setPalette(QPalette(CDlg.color()));
      //WR->setColor(1,CDlg.color());
   }
}

void WrTestDlg::Col2BtnClick() {
KColorDialog CDlg(this,"FARBE WHLEN",TRUE);

   //debug("Col2BtnClick");
   CDlg.setColor(Col2Btn->backgroundColor());
   if (CDlg.exec())
      Col2Btn->setPalette(QPalette(CDlg.color()));
}

void WrTestDlg::Col3BtnClick() {
KColorDialog CDlg(this,"FARBE WHLEN",TRUE);

   //debug("Col3BtnClick");
   CDlg.setColor(Col3Btn->backgroundColor());
   if (CDlg.exec())
      Col3Btn->setPalette(QPalette(CDlg.color()));
}

void WrTestDlg::Col4BtnClick() {
KColorDialog CDlg(this,"FARBE WHLEN",TRUE);

   //debug("Col4BtnClick");
   CDlg.setColor(Col4Btn->backgroundColor());
   if (CDlg.exec())
      Col4Btn->setPalette(QPalette(CDlg.color()));
}

void WrTestDlg::Col5BtnClick() {
KColorDialog CDlg(this,"FARBE WHLEN",TRUE);

   //debug("Col5BtnClick");
   CDlg.setColor(Col5Btn->backgroundColor());
   if (CDlg.exec())
      Col5Btn->setPalette(QPalette(CDlg.color()));
}


void WrTestDlg::ValChange(float Val) {
char s[20];
int i;

   if (WR->getValid()==KWR_VALID)
      sprintf(s,"%0.3f",Val);
   else
      sprintf(s,"-");
   DirEdit->setText(s);

   if (WR->getValid()==KWR_VALID)
     i=WR->directionToIndex(Val,WR->getDetails());
   else
     i=32;
   DirTextSpin->setIndex(i);

   //debug("Val=%0.1f",Val);
}

void WrTestDlg::DirSetIndexBtnClick() {
   WR->indexToDirection(DirTextSpin->getIndex());
}

void WrTestDlg::DirSetTextBtnClick() {
   if (!WR->textToDirection(DirTextSpin->getValue()))
      QApplication::beep();
}

