class QRect
{
public:
  QRect (); 
  %name(QRectPoints) QRect (const QPoint& topleft, const QPoint& bottomright); 
  %name(QRectPointSize) QRect (const QPoint& topleft, const QSize& size) ;
  %name(QRectLTWH) QRect (int left, int top, int width, int height) ;
  bool isNull () const ;
  bool isEmpty () const ;
  bool isValid () const ;
  QRect normalize () const ;
  int left () const ;
  int top () const ;
  int right () const; 
  int bottom () const; 
  int x () const ;
  int y () const ;
  void setLeft (int pos) ;
  void setTop (int pos) ;
  void setRight (int pos) ;
  void setBottom (int pos) ;
  void setX (int x) ;
  void setY (int y) ;
  QPoint topLeft () const; 
  QPoint bottomRight () const; 
  QPoint topRight () const ;
  QPoint bottomLeft () const; 
  QPoint center () const ;
  void rect (int* x, int* y, int* w, int* h) const; 
  void coords (int* x1, int* y1, int* x2, int* y2) const; 
  void moveTopLeft (const QPoint& p) ;
  void moveBottomRight (const QPoint& p); 
  void moveTopRight (const QPoint& p) ;
  void moveBottomLeft (const QPoint& p); 
  void moveCenter (const QPoint& p) ;
  void moveBy (int dx, int dy) ;
  void setRect (int x, int y, int w, int h) ;
  void setCoords (int x1, int y1, int x2, int y2); 
  QSize size () const ;
  int width () const ;
  int height () const ;
  void setWidth (int w); 
  void setHeight (int h); 
  void setSize (const QSize& s); 
  %name(containsPoint) bool contains (const QPoint& p, 
				      bool proper=FALSE) const; 
  %name(containsRect) bool contains (const QRect& r, bool proper=FALSE) const ;
  QRect unite (const QRect& r) const ;
  QRect intersect (const QRect& r) const; 
  bool intersects (const QRect& r) const ;
};
