#include <qpushbt.h>
#include "Object.h"
#include "PushButton.h"

PushButton::PushButton(const char *text, Widget *parent, const char *name)
  : Button(parent,name)	// abstract widget
{
  if(parent)
    pushbutton = new QPushButton(text,parent->widget,name);
  else
    pushbutton = new QPushButton(text,0,name);

  Button::setWidget((QButton*)pushbutton);
}

PushButton::PushButton(Widget *parent=0, const char *name=0)
{
  if(parent)
    pushbutton = new QPushButton(parent->widget,name);
  else
    pushbutton = new QPushButton(NULL,name);

  Button::setWidget((QButton*)pushbutton);
}

void PushButton::setToggleButton(int toggle)
{
  pushbutton->setToggleButton(toggle);
}

bool PushButton::autoDefault() const
{
  return pushbutton->autoDefault();
}

void PushButton::setAutoDefault(int autoDefault)
{
  pushbutton->setAutoDefault(autoDefault);
}

bool PushButton::isDefault() const
{
  return pushbutton->isDefault();
}

void PushButton::setDefault(int def)
{
  pushbutton->setDefault(def);
}

QSize PushButton::sizeHint() const
{
  return pushbutton->sizeHint();
}

void PushButton::move(int x, int y)
{
  pushbutton->move(x,y);
}

void PushButton::move(const QPoint & p)
{
  pushbutton->move(p);
}

void PushButton::resize(int w, int h)
{
  pushbutton->resize(w,h);
}

void PushButton::resize(const QSize& size)
{
  pushbutton->resize(size);
}

void PushButton::setGeometry(int x, int y, int w, int h)
{
  pushbutton->setGeometry(x,y,w,h);
}

void PushButton::setGeometry(const QRect& rect)
{
  pushbutton->setGeometry(rect);
}

void PushButton::setOn(int on)
{
  pushbutton->setOn(on);
}

void PushButton::toggle()
{
  pushbutton->toggle();
}

 
