#ifndef GRIDLAYOUT_H
#define GRIDLAYOUT_H

#include "Layout.h"
#include <qlayout.h>

class GridLayout : public Layout
{
  Q_OBJECT;
public:
  GridLayout(Widget *parent, int nRows, int nCols, int border=0,
	     int autoBorder=-1, const char* name=0);
  GridLayout(int nRows, int nCols, int autoBorder=-1,
				  const char* name=0);

  ~GridLayout();

  void addWidget(Widget *w, int row, int col, int align=0);
  void addMultiCellWidget(Widget *w, int fromRow, int toRow,
			  int fromCol, int toCol, int align=0);
  void addLayout(Layout *layout, int row, int col);
  void setRowStretch(int row, int stretch);
  void setColStretch(int col, int stretch);

  virtual void setLayout(QGridLayout *gl);
  QGridLayout *gridlayout;
};


#endif
