#include "Widget.h"
#include "Application.h"
#include <qlist.h>
#include <qwidget.h>

Application *App = NULL;
char *QtArgv = "Python/Qt";




Application::Application()
{
  if(App)
    {
      printf("Application already initialised!  Cannot do so again!\n");
      return;
    }

  if(!Widgets)
    {
      // printf("Creating widget list!\n");
      Widgets = new QList<Widget>;
    }

  int i = 1;
  a = new QApplication(i, &QtArgv);
  App = this;

  QObject::connect(a, SIGNAL(lastWindowClosed()), this, SLOT(lastWindowClosed()));
  
}

Application::~Application()
{
  // printf("Application destructor!!!!\n");
  // Delete application
  delete a;
  a = NULL;
  // printf("qApp is %p\n",qApp);
  // Delete all widgets
  if(Widgets)
    delete Widgets;
  Widgets = NULL;
  App = NULL;
}


int Application::argc()
{
  return a->argc();
}

char **Application::argv()
{
  return a->argv();
}

Widget *Application::mainWidget()
{
  QWidget *got = a->mainWidget();

  Widget *w;
  for(w = Widgets->first(); w!=0; w = Widgets->next())
    {
      if(w->widget == got)
	return w;
    }
  return NULL;
}

void Application::setMainWidget(Widget *w)
{
  a->setMainWidget(w->widget);
}

Widget *Application::focusWidget()
{
  QWidget *got;
  Widget *w;

  for(w = Widgets->first(); w!=0; w = Widgets->next())
    {
      if(w->widget == got)
	return w;
    }
  return NULL;
}

int Application::exec()
{
  return a->exec();
}

void Application::processEvents()
{
  a->processEvents();
}

int Application::enter_loop()
{
  return a->enter_loop();
}

void Application::exit_loop()
{
  a->exit_loop();
}

void Application::quit()
{
  // printf("Application QUIT!\n");
  a->quit();
}

void Application::lastWindowClosed()
{
  emit("lastWindowClosed", NULL);
}

