/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include <stdio.h>
#include <unistd.h>
#include <qtc/qtc.h>

void setupMenu(qt_QWidget *d);
void actions(int id);
void showThis(qt_QWidget *w);

qt_Slot *actionSlot;
qt_QWidget *currentWidget;
qt_QMenuBar *b;
qt_QPopupMenu *mesgboxes;
qt_QPopupMenu *buttons;
qt_QPopupMenu *style;

#define ABOUT_QT_ID 0
#define INFORMATION_ID 1
#define WARNING_ID 2
#define CRITICAL_ID 3
#define ABOUT_QTC_ID 4

#define PUSH_BUTTON_ID 5
#define CHECK_BUTTON_ID 6
#define RADIO_BUTTON_ID 7

#define WIN_STYLE_ID 8

int main(int argc,char **argv)
{
    qt_QWidget *p1;
    qt_QApplication *app;
    
    /* Create an application */
    app=qt_new_QApplication(argc,argv);
    
    /* A widget, so it gets events*/
    
    p1=qt_new_QWidget (0,"Main dialog",0);
    qt_QWidget_setGeometry ((qt_QWidget *)p1,100,100,500,400);
    
    actionSlot=qt_new_IntSlot(actions);
    setupMenu(p1);
    currentWidget=0;
    
    /* Enter the event loop */
    qt_QApplication_setMainWidget(app,p1);
    qt_QWidget_show (p1);
    qt_QApplication_exec(app);
    /* Avoid warnings ;-) */
    exit (0);
}


void setupMenu(qt_QWidget *d)
{
    /* The main menu bar */
    b=qt_new_QMenuBar((qt_QWidget *)d,"");
    
    /* A popup to show the standard Qt Message Boxes*/
    mesgboxes=qt_new_QPopupMenu(0,"");
    qt_QPopupMenu_insertItem3(mesgboxes,"About Qt",ABOUT_QT_ID,-1);
    qt_QPopupMenu_insertItem3(mesgboxes,"Information",INFORMATION_ID,-1);
    qt_QPopupMenu_insertItem3(mesgboxes,"Warning",WARNING_ID,-1);
    qt_QPopupMenu_insertItem3(mesgboxes,"Critical",CRITICAL_ID,-1);
    qt_QPopupMenu_insertItem3(mesgboxes,"About QtC",ABOUT_QTC_ID,-1);
    qt_QObject_connect((qt_QObject *)mesgboxes,SIGNAL(activated(int)),
                       (qt_QObject *)actionSlot,SLOT(intSlot(int)));
    
    /* A popup to show different button types*/
    buttons=qt_new_QPopupMenu(0,"");
    qt_QPopupMenu_insertItem3(buttons,"Push Button",PUSH_BUTTON_ID,-1);
    qt_QPopupMenu_insertItem3(buttons,"Check Box",CHECK_BUTTON_ID,-1);
    qt_QPopupMenu_insertItem3(buttons,"Radio Button",RADIO_BUTTON_ID,-1);
    qt_QObject_connect((qt_QObject *)buttons,SIGNAL(activated(int)),
                       (qt_QObject *)actionSlot,SLOT(intSlot(int)));

    style=qt_new_QPopupMenu(0,"");
    qt_QPopupMenu_insertItem3(style,"Windows Style",WIN_STYLE_ID,-1);
    qt_QPopupMenu_setCheckable(style,1);
    if (qt_QApplication_style()==1)
        qt_QPopupMenu_setItemChecked(style,WIN_STYLE_ID,1);
    qt_QObject_connect((qt_QObject *)style,SIGNAL(activated(int)),
                       (qt_QObject *)actionSlot,SLOT(intSlot(int)));
    
    
    qt_QMenuBar_insertItem4(b,"MessageBoxes",mesgboxes,-1,-1);
    qt_QMenuBar_insertItem4(b,"Buttons",buttons,-1,-1);
    qt_QMenuBar_insertItem4(b,"Style",style,-1,-1);
}

void actions(int id)
{
    qt_QPushButton *button1=0;

    qt_QButtonGroup *cbbox=0;
    qt_QCheckBox *cb1=0;
    qt_QCheckBox *cb2=0;
    qt_QVBoxLayout *cbl=0;
    
    qt_QButtonGroup *rbbox=0;
    qt_QRadioButton *rb1=0;
    qt_QRadioButton *rb2=0;
    qt_QVBoxLayout *rbl=0;
    
    switch (id)
    {
    case (ABOUT_QT_ID):
        qt_QMessageBox_aboutQt(0,"About Qt (from QtC)");
        break;
    case (INFORMATION_ID):
        qt_QMessageBox_information(0,"Information Box (from QtC)",
                                   "This is just information\n",1,0,0);
        break;
    case (WARNING_ID):
        qt_QMessageBox_information(0,"Warning Box (from QtC)",
                                   "This is a warning, do you care?\n",3,4,0);
        break;
    case (CRITICAL_ID):
        qt_QMessageBox_information(0,"Critical Box (from QtC)",
                                   "This is a critical message!\n",5,6,7);
        break;
    case (ABOUT_QTC_ID):
        qt_QMessageBox_about(0,"About QtC (from QtC)",
                             "This is a demo of QtC\nAuthor: Roberto Alsina <ralsina@unl.edu.ar>\n");
        break;
    case (PUSH_BUTTON_ID):
        if (!button1)
        {
            button1=qt_new_QPushButton1("A Button",0,"");
            qt_QWidget_resize((qt_QWidget *)button1,75,30);
        }
        showThis((qt_QWidget *)button1);
        break;
    case (CHECK_BUTTON_ID):
        if (!cbbox)
        {
            cbbox=qt_new_QButtonGroup1("Choose:",0,"");
            qt_QWidget_resize((qt_QWidget *)cbbox,120,80);
            cb1=qt_new_QCheckBox1("Option 1",(qt_QWidget *)cbbox,"");
            cb2=qt_new_QCheckBox1("Option 2",(qt_QWidget *)cbbox,"");
            cbl=qt_new_QVBoxLayout((qt_QWidget *)cbbox,20,10,"");
            qt_QBoxLayout_addWidget((qt_QBoxLayout *)cbl,(qt_QWidget *)cb1,1,1);
            qt_QBoxLayout_addWidget((qt_QBoxLayout *)cbl,(qt_QWidget *)cb2,1,1);
            qt_QLayout_activate((qt_QLayout *)cbl);
        }
        showThis((qt_QWidget *)cbbox);
        break;
    case (RADIO_BUTTON_ID):
        if (!rbbox)
        {
            rbbox=qt_new_QButtonGroup1("Choose:",0,"");
            qt_QWidget_resize((qt_QWidget *)rbbox,120,80);
            rb1=qt_new_QRadioButton1("Option 1",(qt_QWidget *)rbbox,"");
            rb2=qt_new_QRadioButton1("Option 2",(qt_QWidget *)rbbox,"");
            rbl=qt_new_QVBoxLayout((qt_QWidget *)rbbox,20,10,"");
            qt_QBoxLayout_addWidget((qt_QBoxLayout *)rbl,(qt_QWidget *)rb1,1,1);
            qt_QBoxLayout_addWidget((qt_QBoxLayout *)rbl,(qt_QWidget *)rb2,1,1);
            qt_QLayout_activate((qt_QLayout *)rbl);
        }
        showThis((qt_QWidget *)rbbox);
        break;
    case (WIN_STYLE_ID):
        if (qt_QApplication_style()==1)
        {
            qt_QPopupMenu_setItemChecked(style,WIN_STYLE_ID,0);
            qt_QApplication_setStyle(4);
        }
        else
        {
            qt_QPopupMenu_setItemChecked(style,WIN_STYLE_ID,1);
            qt_QApplication_setStyle(1);
        }
        break;
    }
}

void showThis(qt_QWidget *w)
{
    if (currentWidget)
        qt_QWidget_hide(currentWidget);
    if (currentWidget!=w)
    {
        currentWidget=w;
        qt_QWidget_show(w);
    }
}
