/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#ifndef QT_SLOT_H
#define QT_SLOT_H


#include <qobject.h>
#include "qtc_types.h"

class Slot: public QObject
{
    Q_OBJECT
public:
    Slot();
    ~Slot();
    static Slot *new_IntSlot(qt_intCallback);
    static Slot *new_VoidSlot(qt_voidCallback);
    static Slot *new_FloatSlot(qt_floatCallback);
    static Slot *new_QRectSlot(qt_QRectCallback);
    static Slot *new_QSizeSlot(qt_QSizeCallback);
public slots:
    void intSlot(int i);
    void voidSlot();
    void floatSlot(float f);
    void QRectSlot(QRect f);
    void QSizeSlot(QSize f);
private:
    union
    {
        qt_intCallback intf;
        qt_voidCallback voidf;
        qt_floatCallback floatf;
        qt_QRectCallback qrectf;
        qt_QSizeCallback qsizef;
    };
};
class Signal: public QObject
{
    Q_OBJECT
public:
    Signal();
    ~Signal();
    void emitInt(int);
    void emitVoid();
    void emitFloat(float);
signals:
    void intSignal(int);
    void voidSignal();
    void floatSignal(float);
};

extern "C"
{
qt_Slot *qt_new_IntSlot(qt_intCallback);
qt_Slot *qt_new_VoidSlot(qt_voidCallback);
qt_Slot *qt_new_FloatSlot(qt_floatCallback);
qt_Slot *qt_new_QRectSlot(qt_QRectCallback);
qt_Slot *qt_new_QSizeSlot(qt_QSizeCallback);

qt_Signal *qt_new_Signal();
void qt_emitInt(qt_Signal *s,int i);
void qt_emitVoid(qt_Signal *s);
void qt_emitFloat(qt_Signal *s,float f);
void qt_del_Slot(qt_Slot *s);
void qt_del_Signal(qt_Signal *s);

void qt_connectInt(qt_Slot *sender,qt_QObject receiver,char *member);
void qt_connectVoid(qt_Slot *sender,qt_QObject receiver,char *member);
void qt_connectFloat(qt_Slot *sender,qt_QObject receiver,char *member);
}

#endif