// $Revision: 1.7 $

#include <qobject.h>
#include "threads.h"
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef _REENTRANT 
#error This library needs to be compiled with the _REENTRANT \
       preprocessor variable defined!
#endif


Thread::Thread()
{
  id.set(0);
}

int Thread::start()
{
  bool GUARD; // set to true to see log messages
  GUARD=true;
  // ####################################################################
  pthread_t temp;
  debug("Thread::create: creating thread ... ");
  int rc=pthread_create(&temp, 0, startRoutine, (void*)this);
  if(rc==0)
    {
      id.set(temp);
      debug("success. Thread id is %li.", id.get());
      return 0;
    } else {
      debug("failure. No thread created.");
      return errno;
    }
  // ####################################################################
}

void* Thread::startRoutine(void* arg)
{
  // arg is the this-pointer of the creating object, 
  // handed over by start(..)
  void* rv=((Thread*)arg)->threadMain();
  ((Thread*)arg)->id.set(0);
  return rv;
}

pthread_t Thread::identity() const
{
  return id.get();
}

int Thread::join(const Thread& thread, int* arg)
{ 
  return join(thread.identity(), arg);
}

int Thread::join(pthread_t thread, int* arg)
{
  return pthread_join(thread, (void**)arg);
}

int Thread::joinThread(const Thread& thread, int *rv) // the static method
{
  return pthread_join(thread.identity(), (void**)rv);
}
