%module Slider

%{
#include "Slider.h"
%}


%include Types.i
%include Object.i
%import Rangecontrol.i
%import Widget.i


class Slider : public QWidget, public QRangeControl
{
public:
    enum Orientation { Horizontal, Vertical };
    enum TickSetting { NoMarks = 0, Above = 1, Left = Above, 
		       Below = 2, Right = Below, Both = 3 };

    Slider( int minValue, int maxValue, int step, int value, Orientation,
	     QWidget *parent=0, const char *name=0 );
    ~Slider();

    void	setOrientation( Orientation );
    Orientation orientation() const;
    void	setTracking( bool enable );
    bool	tracking() const;

    QRect	sliderRect() const;

    virtual void setTickmarks( TickSetting );
    TickSetting tickmarks() const { return ticks; }

    virtual void setTickInterval( int );
    int 	tickInterval() const { return tickInt; }

    void	setValue( int );
    void	addStep();
    void	subtractStep();

/*
signals:
    void	valueChanged( int value );
    void	sliderPressed();
    void	sliderMoved( int value );
    void	sliderReleased();
*/

};
