%module Region


%{
#include "Object.h"
#include "Baseobject.h"
#include <qregion.h>
%}


%import Types.i
%import Object.i
%import Baseobject.i


class QRegion : public BaseObject
{
public:

    enum RegionType { Rectangle, Ellipse };

    QRegion();
%name(QRegionRect) QRegion( const QRect &rect, RegionType type= Rectangle );
%name(QRegionPoints) QRegion( const QPointArray &points, bool winding=0 );
%name(QRegionCopy) QRegion( const QRegion &region );
   ~QRegion();


    bool    isNull()   const;
    bool    isEmpty()  const;

    bool    contains( const QPoint &p ) const;
%name(containsRect)    bool    contains( const QRect &r )	const;

    void    translate( int dx, int dy );

    QRegion unite( const QRegion & )	const;
    QRegion intersect( const QRegion &) const;
    QRegion subtract( const QRegion & ) const;

    QRegion eor( const QRegion & )	const;
};

