%module printer

%{
#include <qprinter.h>
%}


%import Baseobject.i
%import Paintdevice.i
%import Painter.i
%import Widget.i


class QPrinter : public QPaintDevice
{
public:
    QPrinter();
   ~QPrinter();

    enum Orientation { Portrait, Landscape };
    enum PageSize    { A4, B5, Letter, Legal, Executive };

    const char *printerName()	const;
    void	setPrinterName( const char * );
    bool	outputToFile()	const;
    void	setOutputToFile( bool );
    const char *outputFileName()const;
    void	setOutputFileName( const char * );
    const char *printProgram()	const;
    void	setPrintProgram( const char * );

    const char *docName()	const;
    void	setDocName( const char * );
    const char *creator()	const;
    void	setCreator( const char * );

    Orientation orientation()	const;
    void	setOrientation( Orientation );
    PageSize	pageSize()	const;
    void	setPageSize( PageSize );

    int		fromPage()	const;
    int		toPage()	const;
    void	setFromTo( int fromPage, int toPage );
    int		minPage()	const;
    int		maxPage()	const;
    void	setMinMax( int minPage, int maxPage );
    int		numCopies()	const;
    void	setNumCopies( int );

    bool	newPage();
    bool	abort();
    bool	aborted()	const;

    bool	setup( QWidget *parent = 0 );
};
