%module Lcdnumber


%{
#include "Object.h"
#include "Button.h"
#include "Lcdnumber.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i
%import Frame.i


class LCDNumber : public QFrame	
{
public:
    LCDNumber(QWidget *parent=0, const char *name=0 );
   ~LCDNumber();

    enum Mode { HEX, DEC, OCT, BIN };
    enum SegmentStyle { Outline, Filled, Flat };

    bool    smallDecimalPoint() const;

    int	    numDigits() const;
    void    setNumDigits( int nDigits );

    bool    checkOverflow( double num ) const;
%name(checkOverflowFloat)    bool    checkOverflow( int	  num ) const;

    Mode mode() const;
    void    setMode( Mode );

    SegmentStyle segmentStyle() const;
    void    setSegmentStyle( SegmentStyle );

    double  value() const;
    int	    intValue() const;

    void    display( int num );
%name(displayFloat)    void    display( double num );
%name(displayString)    void    display( const char *str );
    void    setHexMode();
    void    setDecMode();
    void    setOctMode();
    void    setBinMode();
    void    setSmallDecimalPoint( bool );

/*
signals:
    void    overflow();
*/

};
