%module Combobox


%{
#include "Combobox.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i


class ComboBox : public QWidget
{

public:

    ComboBox(QWidget *parent=0, const char *name=0 );
%name(ComboBoxRW)    ComboBox(bool rw,QWidget *parent=0, const char *name=0 );
   ~ComboBox();

    int		count() const;

    void	insertStrList( const QStrList *, int index=-1 );

    void	insertItem( const char *text, int index=-1 );
%name(insertPixmap)    void	insertItem( const QPixmap &pixmap, int index=-1 );

    void	removeItem( int index );
    void	clear();

    const char *currentText() const;
    const char *text( int index ) const;
    const QPixmap *pixmap( int index ) const;

    void	changeItem( const char *text, int index );
%name(changePixmap)    void	changeItem( const QPixmap &pixmap, int index );

    int		currentItem() const;
    void	setCurrentItem( int index );

    bool	autoResize()	const;
    void	setAutoResize( bool );

    void	setSizeLimit( int );
    int		sizeLimit() const;

    void	setMaxCount( int );
    int		maxCount() const;

    enum Policy { NoInsertion, AtTop, AtCurrent, AtBottom,
		  AfterCurrent, BeforeCurrent };

    void	setInsertionPolicy( Policy policy );
    Policy 	insertionPolicy() const;

/*
signals:
    void	activated( int index );
    void	highlighted( int index );
*/

};


