#ifndef _COMBOBOX_H_
#define _COMBOBOX_H_

#include <Python.h>
#include "qcombo.h"
#include "Baseobject.h"

class ComboBox : public QComboBox, BaseObject
{
  Q_OBJECT	

  public:

  ComboBox(QWidget *parent=0, const char *name=0) : QComboBox(parent,name), BaseObject() {
    connect(this, SIGNAL(activated(int)), this, SLOT(sigActivated(int)));
    connect(this, SIGNAL(highlighted(int)), this, SLOT(sigHighlighted(int)));
  }
  ComboBox(bool rw,QWidget *parent=0, const char *name=0) : QComboBox(rw, parent,name), BaseObject() {
    connect(this, SIGNAL(activated(int)), this, SLOT(sigActivated(int)));
    connect(this, SIGNAL(highlighted(int)), this, SLOT(sigHighlighted(int)));
  }
  ~ComboBox() {};


  public slots:
  
    void sigActivated(int index) {
      PyObject *arg = Py_BuildValue("(i)",index);
      _emit("activated", arg);
      Py_DECREF(arg);
    };

    void sigHighlighted(int index) {
      PyObject *arg = Py_BuildValue("(i)",index);
      _emit("highlighted", arg);
      Py_DECREF(arg);
    };    
  
};

#endif
