import libqtpythonc
from baseobject import *


class QImagePtr(BaseObjectPtr):

    IgnoreEndian = libqtpythonc.QImage_IgnoreEndian
    BigEndian = libqtpythonc.QImage_BigEndian
    LittleEndian = libqtpythonc.QImage_LittleEndian

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QImage(self.this)

    def detach(self):
        val = libqtpythonc.QImage_detach(self.this)
        return val

    def copy(self):
        val = libqtpythonc.QImage_copy(self.this)
        val = QImagePtr(val)
        val.thisown = 1
        return val

    def isNull(self):
        val = libqtpythonc.QImage_isNull(self.this)
        return val

    def width(self):
        val = libqtpythonc.QImage_width(self.this)
        return val

    def height(self):
        val = libqtpythonc.QImage_height(self.this)
        return val

    def size(self):
        val = libqtpythonc.QImage_size(self.this)
        return val

    def rect(self):
        val = libqtpythonc.QImage_rect(self.this)
        return val

    def depth(self):
        val = libqtpythonc.QImage_depth(self.this)
        return val

    def numColors(self):
        val = libqtpythonc.QImage_numColors(self.this)
        return val

    def bitOrder(self):
        val = libqtpythonc.QImage_bitOrder(self.this)
        return val

    def color(self,arg0):
        val = libqtpythonc.QImage_color(self.this,arg0)
        return val

    def setColor(self,arg0,arg1):
        val = libqtpythonc.QImage_setColor(self.this,arg0,arg1)
        return val

    def setNumColors(self,arg0):
        val = libqtpythonc.QImage_setNumColors(self.this,arg0)
        return val

    def hasAlphaBuffer(self):
        val = libqtpythonc.QImage_hasAlphaBuffer(self.this)
        return val

    def setAlphaBuffer(self,arg0):
        val = libqtpythonc.QImage_setAlphaBuffer(self.this,arg0)
        return val

    def bits(self):
        val = libqtpythonc.QImage_bits(self.this)
        return val

    def scanLine(self,arg0):
        val = libqtpythonc.QImage_scanLine(self.this,arg0)
        return val

    def jumpTable(self):
        val = libqtpythonc.QImage_jumpTable(self.this)
        return val

    def colorTable(self):
        val = libqtpythonc.QImage_colorTable(self.this)
        return val

    def numBytes(self):
        val = libqtpythonc.QImage_numBytes(self.this)
        return val

    def bytesPerLine(self):
        val = libqtpythonc.QImage_bytesPerLine(self.this)
        return val

    def create(self,arg0,arg1,*args):
        val = apply(libqtpythonc.QImage_create,(self.this,arg0,arg1,)+args)
        return val

    def reset(self):
        val = libqtpythonc.QImage_reset(self.this)
        return val

    def fill(self,arg0):
        val = libqtpythonc.QImage_fill(self.this,arg0)
        return val

    def convertDepth(self,arg0):
        val = libqtpythonc.QImage_convertDepth(self.this,arg0)
        val = QImagePtr(val)
        val.thisown = 1
        return val

    def convertDepthFlags(self,arg0,arg1):
        val = libqtpythonc.QImage_convertDepthFlags(self.this,arg0,arg1)
        val = QImagePtr(val)
        val.thisown = 1
        return val

    def convertBitOrder(self,arg0):
        val = libqtpythonc.QImage_convertBitOrder(self.this,arg0)
        val = QImagePtr(val)
        val.thisown = 1
        return val

    def createAlphaMask(self,arg0):
        val = libqtpythonc.QImage_createAlphaMask(self.this,arg0)
        val = QImagePtr(val)
        val.thisown = 1
        return val

    def createHeuristicMask(self,*args):
        val = apply(libqtpythonc.QImage_createHeuristicMask,(self.this,)+args)
        val = QImagePtr(val)
        val.thisown = 1
        return val

    def load(self,arg0,*args):
        val = apply(libqtpythonc.QImage_load,(self.this,arg0,)+args)
        return val

    def loadFromData(self,arg0,arg1,*args):
        val = apply(libqtpythonc.QImage_loadFromData,(self.this,arg0,arg1,)+args)
        return val

    def save(self,arg0,arg1):
        val = libqtpythonc.QImage_save(self.this,arg0,arg1)
        return val

    def valid(self,arg0,arg1):
        val = libqtpythonc.QImage_valid(self.this,arg0,arg1)
        return val

    def pixelIndex(self,arg0,arg1):
        val = libqtpythonc.QImage_pixelIndex(self.this,arg0,arg1)
        return val

    def pixel(self,arg0,arg1):
        val = libqtpythonc.QImage_pixel(self.this,arg0,arg1)
        return val

    def setPixel(self,arg0,arg1,arg2):
        val = libqtpythonc.QImage_setPixel(self.this,arg0,arg1,arg2)
        return val

    def __repr__(self):
        return "<Image instance at %s>" % self.this

class QImage(QImagePtr):
    def __init__(self,name="") :
        QImagePtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QImage()
        self.thisown = 1



def QImageSize(size,depth,numColors=0,bitOrder=QImagePtr.IgnoreEndian,name="") :
    val = QImagePtr(libqtpythonc.new_QImageSize(size,depth,numColors,bitOrder),name)
    val.thisown = 1
    return val

def QImageFile(filename,format,name="") :
    val = QImagePtr(libqtpythonc.new_QImageFile(filename,format),name)
    val.thisown = 1
    return val

def QImageCopy(arg0,name="") :
    val = QImagePtr(libqtpythonc.new_QImageCopy(arg0.this),name)
    val.thisown = 1
    return val