import libqtpythonc
from baseobject import *
from color import *


class ColorGroupPtr(BaseObjectPtr):

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QColorGroup(self.this)

    def foreground(self):
        return ColorPtr(libqtpythonc.QColorGroup_foreground(self.this))

    def background(self):
        return ColorPtr(libqtpythonc.QColorGroup_background(self.this))

    def light(self):
        return ColorPtr(libqtpythonc.QColorGroup_light(self.this))

    def midlight(self):
        val = ColorPtr(libqtpythonc.QColorGroup_midlight(self.this))
        val.thisown = 1
        return val

    def dark(self):
        return ColorPtr(libqtpythonc.QColorGroup_dark(self.this))

    def mid(self):
        return ColorPtr(libqtpythonc.QColorGroup_mid(self.this))

    def text(self):
        return ColorPtr(libqtpythonc.QColorGroup_text(self.this))

    def base(self):
        return ColorPtr(libqtpythonc.QColorGroup_base(self.this))

    def __repr__(self):
        return "<ColorGroup instance at %s>" % self.this

class ColorGroup(ColorGroupPtr):

    def __init__(self,name=""):
        ColorGroupPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QColorGroupEmpty()
        self.thisown = 1

def ColorGroup(arg0,arg1,arg2,arg3,arg4,arg5,arg6,name="") :
    val = ColorGroupPtr(libqtpythonc.new_QColorGroup(arg0.this,arg1.this,arg2.this,arg3.this,arg4.this,arg5.this,arg6.this),name)
    val.thisown = 1
    return val

