import libqtpythonc
from object import *
from layout import *

class BoxLayoutPtr(LayoutPtr):

    LeftToRight = libqtpythonc.QBoxLayout_LeftToRight
    RightToLeft = libqtpythonc.QBoxLayout_RightToLeft
    TopToBottom = libqtpythonc.QBoxLayout_TopToBottom
    BottomToTop = libqtpythonc.QBoxLayout_BottomToTop
    Down = libqtpythonc.QBoxLayout_Down
    Up = libqtpythonc.QBoxLayout_Up

    def __init__(self,this,name=""):
        LayoutPtr.__init__(self,this,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QBoxLayout(self.this)

    def addSpacing(self,arg0):
        val = libqtpythonc.QBoxLayout_addSpacing(self.this,arg0)
        return val

    def addStretch(self,*args):
        val = apply(libqtpythonc.QBoxLayout_addStretch,(self.this,)+args)
        return val

    def addWidget(self,arg0,*args):
        val = apply(libqtpythonc.QBoxLayout_addWidget,(self.this,arg0.this,)+args)
        return val

    def addLayout(self,arg0,*args):
        val = apply(libqtpythonc.QBoxLayout_addLayout,(self.this,arg0.this,)+args)
        return val

    def direction(self):
        val = libqtpythonc.QBoxLayout_direction(self.this)
        return val

    def addStrut(self,arg0):
        val = libqtpythonc.QBoxLayout_addStrut(self.this,arg0)
        return val

    def __repr__(self):
        return "<BoxLayout instance at %s>" % self.this

class BoxLayout(BoxLayoutPtr):
    def __init__(self,direction,autoBorder=-1,name="") :
        BoxLayoutPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QBoxLayout(dirction,autoBorder,name)
        self.thisown = 1



def BoxLayoutParent(parent,direction,border=0,autoBorder=-1,name="") :
    val = BoxLayoutPtr(libqtpythonc.new_QBoxLayoutParent(parent.this,direction,border,autoBorder,name),name)
    val.thisown = 1
    return val
