#include "KToolbar.h"
#include "KToolbar.moc"

#include "KLineedit.h"
#include "KCombobox.h"
#include <qtooltip.h>


void _ToolBar::sigPressed(int id) 
{
  PyObject *arg = Py_BuildValue("(i)",id);
  _emit("pressed", arg);  
  Py_DECREF(arg);
};
    
void _ToolBar::sigReleased(int id) 
{
  PyObject *arg = Py_BuildValue("(i)",id);
  _emit("released", arg);  
  Py_DECREF(arg);
};
    
void _ToolBar::sigClicked(int id) 
{
  PyObject *arg = Py_BuildValue("(i)",id);
  _emit("clicked", arg);  
  Py_DECREF(arg);
};
    
void _ToolBar::sigToggled(int id) 
{
  PyObject *arg = Py_BuildValue("(i)",id);
  _emit("toggled", arg);  
  Py_DECREF(arg);
};


int _ToolBar::addButton(const QPixmap& pixmap, int ID, 
	const char *signal, PyObject *slot, 
        bool enabled=true, const char *toolTipText=0,int index=-1) 
{
  _ToolBarButton *bt = new _ToolBarButton(pixmap,ID,this);
  bt->setEnabled(enabled);  
  QToolTip::add(bt,toolTipText);

  int ret = insertWidget(ID,26,bt,index);
  bt->_connect(signal, slot);
  
  return ret;
}


int _ToolBar::addLined(const char *text, int ID,
                   const char *signal, PyObject *slot,
                   bool enabled = true,
                   const char *toolTipText = 0L, int size = 70, int index =-1)
{
  _LineEdit *kl = new _LineEdit(this);
  kl->setText(text);
  kl->setEnabled(enabled);  
  QToolTip::add(kl,toolTipText);

  int ret = insertWidget(ID,size,kl,index);
  kl->_connect(signal, slot);
  
  return ret;
};


int _ToolBar::addComboList(QStrList *list, int ID, bool writable,
                   const char *signal, PyObject *slot,
                   bool enabled=true,
                   const char *toolTipText=0L,
                   int size=70, int index=-1,
                   _ComboBox::Policy policy = _ComboBox::AtBottom)
{
  _ComboBox *cb = new _ComboBox(writable,this);
  cb->insertStrList(list);
  cb->setEnabled(enabled);  
  cb->setInsertionPolicy(policy);
  QToolTip::add(cb,toolTipText);

  int ret = insertWidget(ID,size,cb,index);
  cb->_connect(signal, slot);
  
  return ret;
};


int _ToolBar::addComboText(const char *text, int ID, bool writable,
                   const char *signal, PyObject *slot,
                   bool enabled=true,
                   const char *toolTipText=0L,
                   int size=70, int index=-1,
                   _ComboBox::Policy policy = _ComboBox::AtBottom)
{
  _ComboBox *cb = new _ComboBox(writable,this);
  cb->setText(text);
  cb->setEnabled(enabled);  
  cb->setInsertionPolicy(policy);
  QToolTip::add(cb,toolTipText);

  int ret = insertWidget(ID,size,cb,index);
  cb->_connect(signal, slot);
  
  return ret;
};


void _ToolBar::addConnection (int id, const char *signal, PyObject *slot) 
{
}

