#ifndef _KTABCTL_H_
#define _KTABCTL_H_

#include <Python.h>
#include <ktabctl.h>
#include "Baseobject.h"


class _TabCtl : public KTabCtl, public BaseObject
{
  Q_OBJECT
public:
    _TabCtl(QWidget *parent = 0, const char *name = 0) : KTabCtl(parent,name) {
      connect(this, SIGNAL(tabSelected(int)), this, SLOT(sigTabSelected(int)));
    };
   ~_TabCtl() {};

protected slots:

    void sigTabSelected(int tab) {
       PyObject *arg = Py_BuildValue("(i)",tab);
       _emit("tabSelected", arg);  
       Py_DECREF(arg);
    };

};

#endif
