#ifndef _KSPINBOX_H_
#define _KSPINBOX_H_

#include <Python.h>
#include <kspinbox.h>
#include "Baseobject.h"


class _SpinBox : public KSpinBox, public BaseObject
{
  Q_OBJECT
public:
  _SpinBox(QWidget *parent=0,const char *name=0,int align=AlignLeft) : KSpinBox(parent,name,align), BaseObject() {
      connect(this, SIGNAL(valueIncreased()), this, SLOT(sigValueIncreased()));
      connect(this, SIGNAL(valueDecreased()), this, SLOT(sigValueDecreased()));
  };
  ~_SpinBox() {};

protected slots:

    void sigValueIncreased() {
      _emit("valueIncreased", 0);
    };
    
    void sigValueDecreased() {
      _emit("valueDecreased", 0);
    };
};


class _NumericSpinBox : public KNumericSpinBox, public BaseObject
{
  Q_OBJECT
public:
  _NumericSpinBox(QWidget *parent=0,const char *name=0,int align=AlignLeft) : KNumericSpinBox(parent,name,align), BaseObject() {
      connect(this, SIGNAL(valueIncreased()), this, SLOT(sigValueIncreased()));
      connect(this, SIGNAL(valueDecreased()), this, SLOT(sigValueDecreased()));
  };
  ~_NumericSpinBox() {};

protected slots:

    void sigValueIncreased() {
      _emit("valueIncreased", 0);
    };
    
    void sigValueDecreased() {
      _emit("valueDecreased", 0);
    };
};


class _ListSpinBox : public KListSpinBox, public BaseObject
{
  Q_OBJECT
public:
  _ListSpinBox(QStrList *list,QWidget *parent=0,const char *name=0,int align=AlignLeft) : KListSpinBox(list,parent,name,align), BaseObject() {
      connect(this, SIGNAL(valueIncreased()), this, SLOT(sigValueIncreased()));
      connect(this, SIGNAL(valueDecreased()), this, SLOT(sigValueDecreased()));
  };

protected slots:

    void sigValueIncreased() {
      _emit("valueIncreased", 0);
    };
    
    void sigValueDecreased() {
      _emit("valueDecreased", 0);
    };
};


#endif