%module KProgress


%{
#include "KProgress.h"
%}


%include Types.i
%import Rangecontrol.i


class _Progress : public QFrame, public QRangeControl {
public:

  enum Orientation { Horizontal, Vertical };
  enum BarStyle { Solid, Blocked };

  _Progress(Orientation, QWidget *parent=0, const char *name=0);
%name(_ProgressValues)	_Progress(int minValue, int maxValue, int value, Orientation, 
				QWidget *parent=0, const char *name=0);
  ~_Progress();
	
  void setBarStyle(BarStyle style);  
  void setBarColor(const QColor &); 
  void setBarPixmap(const QPixmap &);
  void setOrientation(Orientation);
  void setTextEnabled(bool);
  BarStyle barStyle() const;
  const QColor &barColor() const;
  const QPixmap *barPixmap() const;
  Orientation orientation() const;
  bool textEnabled() const;

	void setValue(int);
	void advance(int);

/*	
signals:
	void percentageChanged(int);
*/
};
