#ifndef _KFONTDIALOG_H_
#define _KFONTDIALOG_H_

#include <Python.h>
#include <kfontdialog.h>
#include "Baseobject.h"


extern "C" void SWIG_MakePtr(char *, void *, char *);


class _FontDialog : public KFontDialog, public BaseObject
{
  Q_OBJECT
public:

  _FontDialog(QWidget *parent=0, const char *name=0L, bool modal=FALSE, const QStrList *fontlist=0) : KFontDialog(parent,name,modal,fontlist) {
    connect(this, SIGNAL(fontSelected(const QFont&)), this, SLOT(sigFontSelected(const QFont&)));
  };
  ~_FontDialog() {};

protected slots:

    void sigFontSelected(const QFont &newFont ){
       char temp[128];
       SWIG_MakePtr(temp, (char *) &newFont, "_Font_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("fontSelected", arg);  
       Py_DECREF(arg);
    };
};

#endif